package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "MessagePropertyName", 
    "Attributes", 
    "EntityAlias", 
    "ImageType"})
@JsonInclude(Include.NON_NULL)
public class SdkMessageProcessingStepImageRegistration implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("MessagePropertyName")
    protected String messagePropertyName;

    @JsonProperty("Attributes")
    protected List<String> attributes;

    @JsonProperty("Attributes@nextLink")
    protected String attributesNextLink;

    @JsonProperty("EntityAlias")
    protected String entityAlias;

    @JsonProperty("ImageType")
    protected Integer imageType;

    protected SdkMessageProcessingStepImageRegistration() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.SdkMessageProcessingStepImageRegistration";
    }

    @Property(name="MessagePropertyName")
    @JsonIgnore
    public Optional<String> getMessagePropertyName() {
        return Optional.ofNullable(messagePropertyName);
    }

    public SdkMessageProcessingStepImageRegistration withMessagePropertyName(String messagePropertyName) {
        Checks.checkIsAscii(messagePropertyName);
        SdkMessageProcessingStepImageRegistration _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.SdkMessageProcessingStepImageRegistration");
        _x.messagePropertyName = messagePropertyName;
        return _x;
    }

    @Property(name="Attributes")
    @JsonIgnore
    public CollectionPage<String> getAttributes() {
        return new CollectionPage<String>(contextPath, String.class, this.attributes, Optional.ofNullable(attributesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Attributes")
    @JsonIgnore
    public CollectionPage<String> getAttributes(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.attributes, Optional.ofNullable(attributesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="EntityAlias")
    @JsonIgnore
    public Optional<String> getEntityAlias() {
        return Optional.ofNullable(entityAlias);
    }

    public SdkMessageProcessingStepImageRegistration withEntityAlias(String entityAlias) {
        Checks.checkIsAscii(entityAlias);
        SdkMessageProcessingStepImageRegistration _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.SdkMessageProcessingStepImageRegistration");
        _x.entityAlias = entityAlias;
        return _x;
    }

    @Property(name="ImageType")
    @JsonIgnore
    public Optional<Integer> getImageType() {
        return Optional.ofNullable(imageType);
    }

    public SdkMessageProcessingStepImageRegistration withImageType(Integer imageType) {
        SdkMessageProcessingStepImageRegistration _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.SdkMessageProcessingStepImageRegistration");
        _x.imageType = imageType;
        return _x;
    }

    public SdkMessageProcessingStepImageRegistration withUnmappedField(String name, String value) {
        SdkMessageProcessingStepImageRegistration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String messagePropertyName;
        private List<String> attributes;
        private String attributesNextLink;
        private String entityAlias;
        private Integer imageType;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder messagePropertyName(String messagePropertyName) {
            this.messagePropertyName = messagePropertyName;
            this.changedFields = changedFields.add("MessagePropertyName");
            return this;
        }

        public Builder attributes(List<String> attributes) {
            this.attributes = attributes;
            this.changedFields = changedFields.add("Attributes");
            return this;
        }

        public Builder attributes(String... attributes) {
            return attributes(Arrays.asList(attributes));
        }

        public Builder attributesNextLink(String attributesNextLink) {
            this.attributesNextLink = attributesNextLink;
            this.changedFields = changedFields.add("Attributes");
            return this;
        }

        public Builder entityAlias(String entityAlias) {
            this.entityAlias = entityAlias;
            this.changedFields = changedFields.add("EntityAlias");
            return this;
        }

        public Builder imageType(Integer imageType) {
            this.imageType = imageType;
            this.changedFields = changedFields.add("ImageType");
            return this;
        }

        public SdkMessageProcessingStepImageRegistration build() {
            SdkMessageProcessingStepImageRegistration _x = new SdkMessageProcessingStepImageRegistration();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.SdkMessageProcessingStepImageRegistration";
            _x.messagePropertyName = messagePropertyName;
            _x.attributes = attributes;
            _x.attributesNextLink = attributesNextLink;
            _x.entityAlias = entityAlias;
            _x.imageType = imageType;
            return _x;
        }
    }

    private SdkMessageProcessingStepImageRegistration _copy() {
        SdkMessageProcessingStepImageRegistration _x = new SdkMessageProcessingStepImageRegistration();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.messagePropertyName = messagePropertyName;
        _x.attributes = attributes;
        _x.entityAlias = entityAlias;
        _x.imageType = imageType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SdkMessageProcessingStepImageRegistration[");
        b.append("MessagePropertyName=");
        b.append(this.messagePropertyName);
        b.append(", ");
        b.append("Attributes=");
        b.append(this.attributes);
        b.append(", ");
        b.append("EntityAlias=");
        b.append(this.entityAlias);
        b.append(", ");
        b.append("ImageType=");
        b.append(this.imageType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
