package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "RetrieveInstalledLanguagePacks"})
@JsonInclude(Include.NON_NULL)
public class RetrieveInstalledLanguagePacksResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("RetrieveInstalledLanguagePacks")
    protected List<Integer> retrieveInstalledLanguagePacks;

    @JsonProperty("RetrieveInstalledLanguagePacks@nextLink")
    protected String retrieveInstalledLanguagePacksNextLink;

    protected RetrieveInstalledLanguagePacksResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.RetrieveInstalledLanguagePacksResponse";
    }

    @Property(name="RetrieveInstalledLanguagePacks")
    @JsonIgnore
    public CollectionPage<Integer> getRetrieveInstalledLanguagePacks() {
        return new CollectionPage<Integer>(contextPath, Integer.class, this.retrieveInstalledLanguagePacks, Optional.ofNullable(retrieveInstalledLanguagePacksNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="RetrieveInstalledLanguagePacks")
    @JsonIgnore
    public CollectionPage<Integer> getRetrieveInstalledLanguagePacks(HttpRequestOptions options) {
        return new CollectionPage<Integer>(contextPath, Integer.class, this.retrieveInstalledLanguagePacks, Optional.ofNullable(retrieveInstalledLanguagePacksNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    public RetrieveInstalledLanguagePacksResponse withUnmappedField(String name, String value) {
        RetrieveInstalledLanguagePacksResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<Integer> retrieveInstalledLanguagePacks;
        private String retrieveInstalledLanguagePacksNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder retrieveInstalledLanguagePacks(List<Integer> retrieveInstalledLanguagePacks) {
            this.retrieveInstalledLanguagePacks = retrieveInstalledLanguagePacks;
            this.changedFields = changedFields.add("RetrieveInstalledLanguagePacks");
            return this;
        }

        public Builder retrieveInstalledLanguagePacks(Integer... retrieveInstalledLanguagePacks) {
            return retrieveInstalledLanguagePacks(Arrays.asList(retrieveInstalledLanguagePacks));
        }

        public Builder retrieveInstalledLanguagePacksNextLink(String retrieveInstalledLanguagePacksNextLink) {
            this.retrieveInstalledLanguagePacksNextLink = retrieveInstalledLanguagePacksNextLink;
            this.changedFields = changedFields.add("RetrieveInstalledLanguagePacks");
            return this;
        }

        public RetrieveInstalledLanguagePacksResponse build() {
            RetrieveInstalledLanguagePacksResponse _x = new RetrieveInstalledLanguagePacksResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.RetrieveInstalledLanguagePacksResponse";
            _x.retrieveInstalledLanguagePacks = retrieveInstalledLanguagePacks;
            _x.retrieveInstalledLanguagePacksNextLink = retrieveInstalledLanguagePacksNextLink;
            return _x;
        }
    }

    private RetrieveInstalledLanguagePacksResponse _copy() {
        RetrieveInstalledLanguagePacksResponse _x = new RetrieveInstalledLanguagePacksResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.retrieveInstalledLanguagePacks = retrieveInstalledLanguagePacks;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RetrieveInstalledLanguagePacksResponse[");
        b.append("RetrieveInstalledLanguagePacks=");
        b.append(this.retrieveInstalledLanguagePacks);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
