package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "RetrieveDeprovisionedLanguages"})
@JsonInclude(Include.NON_NULL)
public class RetrieveDeprovisionedLanguagesResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("RetrieveDeprovisionedLanguages")
    protected List<Integer> retrieveDeprovisionedLanguages;

    @JsonProperty("RetrieveDeprovisionedLanguages@nextLink")
    protected String retrieveDeprovisionedLanguagesNextLink;

    protected RetrieveDeprovisionedLanguagesResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.RetrieveDeprovisionedLanguagesResponse";
    }

    @Property(name="RetrieveDeprovisionedLanguages")
    @JsonIgnore
    public CollectionPage<Integer> getRetrieveDeprovisionedLanguages() {
        return new CollectionPage<Integer>(contextPath, Integer.class, this.retrieveDeprovisionedLanguages, Optional.ofNullable(retrieveDeprovisionedLanguagesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="RetrieveDeprovisionedLanguages")
    @JsonIgnore
    public CollectionPage<Integer> getRetrieveDeprovisionedLanguages(HttpRequestOptions options) {
        return new CollectionPage<Integer>(contextPath, Integer.class, this.retrieveDeprovisionedLanguages, Optional.ofNullable(retrieveDeprovisionedLanguagesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    public RetrieveDeprovisionedLanguagesResponse withUnmappedField(String name, String value) {
        RetrieveDeprovisionedLanguagesResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<Integer> retrieveDeprovisionedLanguages;
        private String retrieveDeprovisionedLanguagesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder retrieveDeprovisionedLanguages(List<Integer> retrieveDeprovisionedLanguages) {
            this.retrieveDeprovisionedLanguages = retrieveDeprovisionedLanguages;
            this.changedFields = changedFields.add("RetrieveDeprovisionedLanguages");
            return this;
        }

        public Builder retrieveDeprovisionedLanguages(Integer... retrieveDeprovisionedLanguages) {
            return retrieveDeprovisionedLanguages(Arrays.asList(retrieveDeprovisionedLanguages));
        }

        public Builder retrieveDeprovisionedLanguagesNextLink(String retrieveDeprovisionedLanguagesNextLink) {
            this.retrieveDeprovisionedLanguagesNextLink = retrieveDeprovisionedLanguagesNextLink;
            this.changedFields = changedFields.add("RetrieveDeprovisionedLanguages");
            return this;
        }

        public RetrieveDeprovisionedLanguagesResponse build() {
            RetrieveDeprovisionedLanguagesResponse _x = new RetrieveDeprovisionedLanguagesResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.RetrieveDeprovisionedLanguagesResponse";
            _x.retrieveDeprovisionedLanguages = retrieveDeprovisionedLanguages;
            _x.retrieveDeprovisionedLanguagesNextLink = retrieveDeprovisionedLanguagesNextLink;
            return _x;
        }
    }

    private RetrieveDeprovisionedLanguagesResponse _copy() {
        RetrieveDeprovisionedLanguagesResponse _x = new RetrieveDeprovisionedLanguagesResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.retrieveDeprovisionedLanguages = retrieveDeprovisionedLanguages;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RetrieveDeprovisionedLanguagesResponse[");
        b.append("RetrieveDeprovisionedLanguages=");
        b.append(this.retrieveDeprovisionedLanguages);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
