package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "ViewId", 
    "ViewName", 
    "Columns", 
    "FetchXml", 
    "LayoutJson"})
@JsonInclude(Include.NON_NULL)
public class LookupView implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ViewId")
    protected String viewId;

    @JsonProperty("ViewName")
    protected String viewName;

    @JsonProperty("Columns")
    protected List<ViewColumn> columns;

    @JsonProperty("Columns@nextLink")
    protected String columnsNextLink;

    @JsonProperty("FetchXml")
    protected String fetchXml;

    @JsonProperty("LayoutJson")
    protected String layoutJson;

    protected LookupView() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.LookupView";
    }

    @Property(name="ViewId")
    @JsonIgnore
    public Optional<String> getViewId() {
        return Optional.ofNullable(viewId);
    }

    public LookupView withViewId(String viewId) {
        LookupView _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LookupView");
        _x.viewId = viewId;
        return _x;
    }

    @Property(name="ViewName")
    @JsonIgnore
    public Optional<String> getViewName() {
        return Optional.ofNullable(viewName);
    }

    public LookupView withViewName(String viewName) {
        Checks.checkIsAscii(viewName);
        LookupView _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LookupView");
        _x.viewName = viewName;
        return _x;
    }

    @Property(name="Columns")
    @JsonIgnore
    public CollectionPage<ViewColumn> getColumns() {
        return new CollectionPage<ViewColumn>(contextPath, ViewColumn.class, this.columns, Optional.ofNullable(columnsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Columns")
    @JsonIgnore
    public CollectionPage<ViewColumn> getColumns(HttpRequestOptions options) {
        return new CollectionPage<ViewColumn>(contextPath, ViewColumn.class, this.columns, Optional.ofNullable(columnsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="FetchXml")
    @JsonIgnore
    public Optional<String> getFetchXml() {
        return Optional.ofNullable(fetchXml);
    }

    public LookupView withFetchXml(String fetchXml) {
        Checks.checkIsAscii(fetchXml);
        LookupView _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LookupView");
        _x.fetchXml = fetchXml;
        return _x;
    }

    @Property(name="LayoutJson")
    @JsonIgnore
    public Optional<String> getLayoutJson() {
        return Optional.ofNullable(layoutJson);
    }

    public LookupView withLayoutJson(String layoutJson) {
        Checks.checkIsAscii(layoutJson);
        LookupView _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LookupView");
        _x.layoutJson = layoutJson;
        return _x;
    }

    public LookupView withUnmappedField(String name, String value) {
        LookupView _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String viewId;
        private String viewName;
        private List<ViewColumn> columns;
        private String columnsNextLink;
        private String fetchXml;
        private String layoutJson;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder viewId(String viewId) {
            this.viewId = viewId;
            this.changedFields = changedFields.add("ViewId");
            return this;
        }

        public Builder viewName(String viewName) {
            this.viewName = viewName;
            this.changedFields = changedFields.add("ViewName");
            return this;
        }

        public Builder columns(List<ViewColumn> columns) {
            this.columns = columns;
            this.changedFields = changedFields.add("Columns");
            return this;
        }

        public Builder columns(ViewColumn... columns) {
            return columns(Arrays.asList(columns));
        }

        public Builder columnsNextLink(String columnsNextLink) {
            this.columnsNextLink = columnsNextLink;
            this.changedFields = changedFields.add("Columns");
            return this;
        }

        public Builder fetchXml(String fetchXml) {
            this.fetchXml = fetchXml;
            this.changedFields = changedFields.add("FetchXml");
            return this;
        }

        public Builder layoutJson(String layoutJson) {
            this.layoutJson = layoutJson;
            this.changedFields = changedFields.add("LayoutJson");
            return this;
        }

        public LookupView build() {
            LookupView _x = new LookupView();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.LookupView";
            _x.viewId = viewId;
            _x.viewName = viewName;
            _x.columns = columns;
            _x.columnsNextLink = columnsNextLink;
            _x.fetchXml = fetchXml;
            _x.layoutJson = layoutJson;
            return _x;
        }
    }

    private LookupView _copy() {
        LookupView _x = new LookupView();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.viewId = viewId;
        _x.viewName = viewName;
        _x.columns = columns;
        _x.fetchXml = fetchXml;
        _x.layoutJson = layoutJson;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LookupView[");
        b.append("ViewId=");
        b.append(this.viewId);
        b.append(", ");
        b.append("ViewName=");
        b.append(this.viewName);
        b.append(", ");
        b.append("Columns=");
        b.append(this.columns);
        b.append(", ");
        b.append("FetchXml=");
        b.append(this.fetchXml);
        b.append(", ");
        b.append("LayoutJson=");
        b.append(this.layoutJson);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
