package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "LookupEntityByName", 
    "EntityAndAttribute", 
    "AppId", 
    "RelatedRecordId", 
    "QueryString", 
    "ReturnMetadata"})
@JsonInclude(Include.NON_NULL)
public class LookupDataRequest implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("LookupEntityByName")
    protected List<LookupEntityInfo> lookupEntityByName;

    @JsonProperty("LookupEntityByName@nextLink")
    protected String lookupEntityByNameNextLink;

    @JsonProperty("EntityAndAttribute")
    protected EntityAndAttribute entityAndAttribute;

    @JsonProperty("AppId")
    protected String appId;

    @JsonProperty("RelatedRecordId")
    protected String relatedRecordId;

    @JsonProperty("QueryString")
    protected String queryString;

    @JsonProperty("ReturnMetadata")
    protected Boolean returnMetadata;

    protected LookupDataRequest() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.LookupDataRequest";
    }

    @Property(name="LookupEntityByName")
    @JsonIgnore
    public CollectionPage<LookupEntityInfo> getLookupEntityByName() {
        return new CollectionPage<LookupEntityInfo>(contextPath, LookupEntityInfo.class, this.lookupEntityByName, Optional.ofNullable(lookupEntityByNameNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="LookupEntityByName")
    @JsonIgnore
    public CollectionPage<LookupEntityInfo> getLookupEntityByName(HttpRequestOptions options) {
        return new CollectionPage<LookupEntityInfo>(contextPath, LookupEntityInfo.class, this.lookupEntityByName, Optional.ofNullable(lookupEntityByNameNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="EntityAndAttribute")
    @JsonIgnore
    public Optional<EntityAndAttribute> getEntityAndAttribute() {
        return Optional.ofNullable(entityAndAttribute);
    }

    public LookupDataRequest withEntityAndAttribute(EntityAndAttribute entityAndAttribute) {
        LookupDataRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LookupDataRequest");
        _x.entityAndAttribute = entityAndAttribute;
        return _x;
    }

    @Property(name="AppId")
    @JsonIgnore
    public Optional<String> getAppId() {
        return Optional.ofNullable(appId);
    }

    public LookupDataRequest withAppId(String appId) {
        LookupDataRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LookupDataRequest");
        _x.appId = appId;
        return _x;
    }

    @Property(name="RelatedRecordId")
    @JsonIgnore
    public Optional<String> getRelatedRecordId() {
        return Optional.ofNullable(relatedRecordId);
    }

    public LookupDataRequest withRelatedRecordId(String relatedRecordId) {
        LookupDataRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LookupDataRequest");
        _x.relatedRecordId = relatedRecordId;
        return _x;
    }

    @Property(name="QueryString")
    @JsonIgnore
    public Optional<String> getQueryString() {
        return Optional.ofNullable(queryString);
    }

    public LookupDataRequest withQueryString(String queryString) {
        Checks.checkIsAscii(queryString);
        LookupDataRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LookupDataRequest");
        _x.queryString = queryString;
        return _x;
    }

    @Property(name="ReturnMetadata")
    @JsonIgnore
    public Optional<Boolean> getReturnMetadata() {
        return Optional.ofNullable(returnMetadata);
    }

    public LookupDataRequest withReturnMetadata(Boolean returnMetadata) {
        LookupDataRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LookupDataRequest");
        _x.returnMetadata = returnMetadata;
        return _x;
    }

    public LookupDataRequest withUnmappedField(String name, String value) {
        LookupDataRequest _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<LookupEntityInfo> lookupEntityByName;
        private String lookupEntityByNameNextLink;
        private EntityAndAttribute entityAndAttribute;
        private String appId;
        private String relatedRecordId;
        private String queryString;
        private Boolean returnMetadata;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder lookupEntityByName(List<LookupEntityInfo> lookupEntityByName) {
            this.lookupEntityByName = lookupEntityByName;
            this.changedFields = changedFields.add("LookupEntityByName");
            return this;
        }

        public Builder lookupEntityByName(LookupEntityInfo... lookupEntityByName) {
            return lookupEntityByName(Arrays.asList(lookupEntityByName));
        }

        public Builder lookupEntityByNameNextLink(String lookupEntityByNameNextLink) {
            this.lookupEntityByNameNextLink = lookupEntityByNameNextLink;
            this.changedFields = changedFields.add("LookupEntityByName");
            return this;
        }

        public Builder entityAndAttribute(EntityAndAttribute entityAndAttribute) {
            this.entityAndAttribute = entityAndAttribute;
            this.changedFields = changedFields.add("EntityAndAttribute");
            return this;
        }

        public Builder appId(String appId) {
            this.appId = appId;
            this.changedFields = changedFields.add("AppId");
            return this;
        }

        public Builder relatedRecordId(String relatedRecordId) {
            this.relatedRecordId = relatedRecordId;
            this.changedFields = changedFields.add("RelatedRecordId");
            return this;
        }

        public Builder queryString(String queryString) {
            this.queryString = queryString;
            this.changedFields = changedFields.add("QueryString");
            return this;
        }

        public Builder returnMetadata(Boolean returnMetadata) {
            this.returnMetadata = returnMetadata;
            this.changedFields = changedFields.add("ReturnMetadata");
            return this;
        }

        public LookupDataRequest build() {
            LookupDataRequest _x = new LookupDataRequest();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.LookupDataRequest";
            _x.lookupEntityByName = lookupEntityByName;
            _x.lookupEntityByNameNextLink = lookupEntityByNameNextLink;
            _x.entityAndAttribute = entityAndAttribute;
            _x.appId = appId;
            _x.relatedRecordId = relatedRecordId;
            _x.queryString = queryString;
            _x.returnMetadata = returnMetadata;
            return _x;
        }
    }

    private LookupDataRequest _copy() {
        LookupDataRequest _x = new LookupDataRequest();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.lookupEntityByName = lookupEntityByName;
        _x.entityAndAttribute = entityAndAttribute;
        _x.appId = appId;
        _x.relatedRecordId = relatedRecordId;
        _x.queryString = queryString;
        _x.returnMetadata = returnMetadata;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LookupDataRequest[");
        b.append("LookupEntityByName=");
        b.append(this.lookupEntityByName);
        b.append(", ");
        b.append("EntityAndAttribute=");
        b.append(this.entityAndAttribute);
        b.append(", ");
        b.append("AppId=");
        b.append(this.appId);
        b.append(", ");
        b.append("RelatedRecordId=");
        b.append(this.relatedRecordId);
        b.append(", ");
        b.append("QueryString=");
        b.append(this.queryString);
        b.append(", ");
        b.append("ReturnMetadata=");
        b.append(this.returnMetadata);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
