package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import microsoft.dynamics.crm.enums.JoinOperator;
import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "LinkFromAttributeName", 
    "LinkFromEntityName", 
    "LinkToEntityName", 
    "LinkToAttributeName", 
    "JoinOperator", 
    "LinkCriteria", 
    "LinkEntities", 
    "Columns", 
    "EntityAlias", 
    "Orders"})
@JsonInclude(Include.NON_NULL)
public class LinkEntity implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("LinkFromAttributeName")
    protected String linkFromAttributeName;

    @JsonProperty("LinkFromEntityName")
    protected String linkFromEntityName;

    @JsonProperty("LinkToEntityName")
    protected String linkToEntityName;

    @JsonProperty("LinkToAttributeName")
    protected String linkToAttributeName;

    @JsonProperty("JoinOperator")
    protected JoinOperator joinOperator;

    @JsonProperty("LinkCriteria")
    protected FilterExpression linkCriteria;

    @JsonProperty("LinkEntities")
    protected List<LinkEntity> linkEntities;

    @JsonProperty("LinkEntities@nextLink")
    protected String linkEntitiesNextLink;

    @JsonProperty("Columns")
    protected ColumnSet columns;

    @JsonProperty("EntityAlias")
    protected String entityAlias;

    @JsonProperty("Orders")
    protected List<OrderExpression> orders;

    @JsonProperty("Orders@nextLink")
    protected String ordersNextLink;

    protected LinkEntity() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.LinkEntity";
    }

    @Property(name="LinkFromAttributeName")
    @JsonIgnore
    public Optional<String> getLinkFromAttributeName() {
        return Optional.ofNullable(linkFromAttributeName);
    }

    public LinkEntity withLinkFromAttributeName(String linkFromAttributeName) {
        Checks.checkIsAscii(linkFromAttributeName);
        LinkEntity _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LinkEntity");
        _x.linkFromAttributeName = linkFromAttributeName;
        return _x;
    }

    @Property(name="LinkFromEntityName")
    @JsonIgnore
    public Optional<String> getLinkFromEntityName() {
        return Optional.ofNullable(linkFromEntityName);
    }

    public LinkEntity withLinkFromEntityName(String linkFromEntityName) {
        Checks.checkIsAscii(linkFromEntityName);
        LinkEntity _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LinkEntity");
        _x.linkFromEntityName = linkFromEntityName;
        return _x;
    }

    @Property(name="LinkToEntityName")
    @JsonIgnore
    public Optional<String> getLinkToEntityName() {
        return Optional.ofNullable(linkToEntityName);
    }

    public LinkEntity withLinkToEntityName(String linkToEntityName) {
        Checks.checkIsAscii(linkToEntityName);
        LinkEntity _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LinkEntity");
        _x.linkToEntityName = linkToEntityName;
        return _x;
    }

    @Property(name="LinkToAttributeName")
    @JsonIgnore
    public Optional<String> getLinkToAttributeName() {
        return Optional.ofNullable(linkToAttributeName);
    }

    public LinkEntity withLinkToAttributeName(String linkToAttributeName) {
        Checks.checkIsAscii(linkToAttributeName);
        LinkEntity _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LinkEntity");
        _x.linkToAttributeName = linkToAttributeName;
        return _x;
    }

    @Property(name="JoinOperator")
    @JsonIgnore
    public Optional<JoinOperator> getJoinOperator() {
        return Optional.ofNullable(joinOperator);
    }

    public LinkEntity withJoinOperator(JoinOperator joinOperator) {
        LinkEntity _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LinkEntity");
        _x.joinOperator = joinOperator;
        return _x;
    }

    @Property(name="LinkCriteria")
    @JsonIgnore
    public Optional<FilterExpression> getLinkCriteria() {
        return Optional.ofNullable(linkCriteria);
    }

    public LinkEntity withLinkCriteria(FilterExpression linkCriteria) {
        LinkEntity _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LinkEntity");
        _x.linkCriteria = linkCriteria;
        return _x;
    }

    @Property(name="LinkEntities")
    @JsonIgnore
    public CollectionPage<LinkEntity> getLinkEntities() {
        return new CollectionPage<LinkEntity>(contextPath, LinkEntity.class, this.linkEntities, Optional.ofNullable(linkEntitiesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="LinkEntities")
    @JsonIgnore
    public CollectionPage<LinkEntity> getLinkEntities(HttpRequestOptions options) {
        return new CollectionPage<LinkEntity>(contextPath, LinkEntity.class, this.linkEntities, Optional.ofNullable(linkEntitiesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="Columns")
    @JsonIgnore
    public Optional<ColumnSet> getColumns() {
        return Optional.ofNullable(columns);
    }

    public LinkEntity withColumns(ColumnSet columns) {
        LinkEntity _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LinkEntity");
        _x.columns = columns;
        return _x;
    }

    @Property(name="EntityAlias")
    @JsonIgnore
    public Optional<String> getEntityAlias() {
        return Optional.ofNullable(entityAlias);
    }

    public LinkEntity withEntityAlias(String entityAlias) {
        Checks.checkIsAscii(entityAlias);
        LinkEntity _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LinkEntity");
        _x.entityAlias = entityAlias;
        return _x;
    }

    @Property(name="Orders")
    @JsonIgnore
    public CollectionPage<OrderExpression> getOrders() {
        return new CollectionPage<OrderExpression>(contextPath, OrderExpression.class, this.orders, Optional.ofNullable(ordersNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Orders")
    @JsonIgnore
    public CollectionPage<OrderExpression> getOrders(HttpRequestOptions options) {
        return new CollectionPage<OrderExpression>(contextPath, OrderExpression.class, this.orders, Optional.ofNullable(ordersNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    public LinkEntity withUnmappedField(String name, String value) {
        LinkEntity _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String linkFromAttributeName;
        private String linkFromEntityName;
        private String linkToEntityName;
        private String linkToAttributeName;
        private JoinOperator joinOperator;
        private FilterExpression linkCriteria;
        private List<LinkEntity> linkEntities;
        private String linkEntitiesNextLink;
        private ColumnSet columns;
        private String entityAlias;
        private List<OrderExpression> orders;
        private String ordersNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder linkFromAttributeName(String linkFromAttributeName) {
            this.linkFromAttributeName = linkFromAttributeName;
            this.changedFields = changedFields.add("LinkFromAttributeName");
            return this;
        }

        public Builder linkFromEntityName(String linkFromEntityName) {
            this.linkFromEntityName = linkFromEntityName;
            this.changedFields = changedFields.add("LinkFromEntityName");
            return this;
        }

        public Builder linkToEntityName(String linkToEntityName) {
            this.linkToEntityName = linkToEntityName;
            this.changedFields = changedFields.add("LinkToEntityName");
            return this;
        }

        public Builder linkToAttributeName(String linkToAttributeName) {
            this.linkToAttributeName = linkToAttributeName;
            this.changedFields = changedFields.add("LinkToAttributeName");
            return this;
        }

        public Builder joinOperator(JoinOperator joinOperator) {
            this.joinOperator = joinOperator;
            this.changedFields = changedFields.add("JoinOperator");
            return this;
        }

        public Builder linkCriteria(FilterExpression linkCriteria) {
            this.linkCriteria = linkCriteria;
            this.changedFields = changedFields.add("LinkCriteria");
            return this;
        }

        public Builder linkEntities(List<LinkEntity> linkEntities) {
            this.linkEntities = linkEntities;
            this.changedFields = changedFields.add("LinkEntities");
            return this;
        }

        public Builder linkEntities(LinkEntity... linkEntities) {
            return linkEntities(Arrays.asList(linkEntities));
        }

        public Builder linkEntitiesNextLink(String linkEntitiesNextLink) {
            this.linkEntitiesNextLink = linkEntitiesNextLink;
            this.changedFields = changedFields.add("LinkEntities");
            return this;
        }

        public Builder columns(ColumnSet columns) {
            this.columns = columns;
            this.changedFields = changedFields.add("Columns");
            return this;
        }

        public Builder entityAlias(String entityAlias) {
            this.entityAlias = entityAlias;
            this.changedFields = changedFields.add("EntityAlias");
            return this;
        }

        public Builder orders(List<OrderExpression> orders) {
            this.orders = orders;
            this.changedFields = changedFields.add("Orders");
            return this;
        }

        public Builder orders(OrderExpression... orders) {
            return orders(Arrays.asList(orders));
        }

        public Builder ordersNextLink(String ordersNextLink) {
            this.ordersNextLink = ordersNextLink;
            this.changedFields = changedFields.add("Orders");
            return this;
        }

        public LinkEntity build() {
            LinkEntity _x = new LinkEntity();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.LinkEntity";
            _x.linkFromAttributeName = linkFromAttributeName;
            _x.linkFromEntityName = linkFromEntityName;
            _x.linkToEntityName = linkToEntityName;
            _x.linkToAttributeName = linkToAttributeName;
            _x.joinOperator = joinOperator;
            _x.linkCriteria = linkCriteria;
            _x.linkEntities = linkEntities;
            _x.linkEntitiesNextLink = linkEntitiesNextLink;
            _x.columns = columns;
            _x.entityAlias = entityAlias;
            _x.orders = orders;
            _x.ordersNextLink = ordersNextLink;
            return _x;
        }
    }

    private LinkEntity _copy() {
        LinkEntity _x = new LinkEntity();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.linkFromAttributeName = linkFromAttributeName;
        _x.linkFromEntityName = linkFromEntityName;
        _x.linkToEntityName = linkToEntityName;
        _x.linkToAttributeName = linkToAttributeName;
        _x.joinOperator = joinOperator;
        _x.linkCriteria = linkCriteria;
        _x.linkEntities = linkEntities;
        _x.columns = columns;
        _x.entityAlias = entityAlias;
        _x.orders = orders;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LinkEntity[");
        b.append("LinkFromAttributeName=");
        b.append(this.linkFromAttributeName);
        b.append(", ");
        b.append("LinkFromEntityName=");
        b.append(this.linkFromEntityName);
        b.append(", ");
        b.append("LinkToEntityName=");
        b.append(this.linkToEntityName);
        b.append(", ");
        b.append("LinkToAttributeName=");
        b.append(this.linkToAttributeName);
        b.append(", ");
        b.append("JoinOperator=");
        b.append(this.joinOperator);
        b.append(", ");
        b.append("LinkCriteria=");
        b.append(this.linkCriteria);
        b.append(", ");
        b.append("LinkEntities=");
        b.append(this.linkEntities);
        b.append(", ");
        b.append("Columns=");
        b.append(this.columns);
        b.append(", ");
        b.append("EntityAlias=");
        b.append(this.entityAlias);
        b.append(", ");
        b.append("Orders=");
        b.append(this.orders);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
