package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "ValidationResult", 
    "Notifications"})
@JsonInclude(Include.NON_NULL)
public class ImmediateBookResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ValidationResult")
    protected ValidationResult validationResult;

    @JsonProperty("Notifications")
    protected List<BusinessNotification> notifications;

    @JsonProperty("Notifications@nextLink")
    protected String notificationsNextLink;

    protected ImmediateBookResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ImmediateBookResponse";
    }

    @Property(name="ValidationResult")
    @JsonIgnore
    public Optional<ValidationResult> getValidationResult() {
        return Optional.ofNullable(validationResult);
    }

    public ImmediateBookResponse withValidationResult(ValidationResult validationResult) {
        ImmediateBookResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ImmediateBookResponse");
        _x.validationResult = validationResult;
        return _x;
    }

    @Property(name="Notifications")
    @JsonIgnore
    public CollectionPage<BusinessNotification> getNotifications() {
        return new CollectionPage<BusinessNotification>(contextPath, BusinessNotification.class, this.notifications, Optional.ofNullable(notificationsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Notifications")
    @JsonIgnore
    public CollectionPage<BusinessNotification> getNotifications(HttpRequestOptions options) {
        return new CollectionPage<BusinessNotification>(contextPath, BusinessNotification.class, this.notifications, Optional.ofNullable(notificationsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    public ImmediateBookResponse withUnmappedField(String name, String value) {
        ImmediateBookResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ValidationResult validationResult;
        private List<BusinessNotification> notifications;
        private String notificationsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder validationResult(ValidationResult validationResult) {
            this.validationResult = validationResult;
            this.changedFields = changedFields.add("ValidationResult");
            return this;
        }

        public Builder notifications(List<BusinessNotification> notifications) {
            this.notifications = notifications;
            this.changedFields = changedFields.add("Notifications");
            return this;
        }

        public Builder notifications(BusinessNotification... notifications) {
            return notifications(Arrays.asList(notifications));
        }

        public Builder notificationsNextLink(String notificationsNextLink) {
            this.notificationsNextLink = notificationsNextLink;
            this.changedFields = changedFields.add("Notifications");
            return this;
        }

        public ImmediateBookResponse build() {
            ImmediateBookResponse _x = new ImmediateBookResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ImmediateBookResponse";
            _x.validationResult = validationResult;
            _x.notifications = notifications;
            _x.notificationsNextLink = notificationsNextLink;
            return _x;
        }
    }

    private ImmediateBookResponse _copy() {
        ImmediateBookResponse _x = new ImmediateBookResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.validationResult = validationResult;
        _x.notifications = notifications;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ImmediateBookResponse[");
        b.append("ValidationResult=");
        b.append(this.validationResult);
        b.append(", ");
        b.append("Notifications=");
        b.append(this.notifications);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
