package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "EntityNames"})
@JsonInclude(Include.NON_NULL)
public class GetValidManyToManyResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("EntityNames")
    protected List<String> entityNames;

    @JsonProperty("EntityNames@nextLink")
    protected String entityNamesNextLink;

    protected GetValidManyToManyResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.GetValidManyToManyResponse";
    }

    @Property(name="EntityNames")
    @JsonIgnore
    public CollectionPage<String> getEntityNames() {
        return new CollectionPage<String>(contextPath, String.class, this.entityNames, Optional.ofNullable(entityNamesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="EntityNames")
    @JsonIgnore
    public CollectionPage<String> getEntityNames(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.entityNames, Optional.ofNullable(entityNamesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    public GetValidManyToManyResponse withUnmappedField(String name, String value) {
        GetValidManyToManyResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> entityNames;
        private String entityNamesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder entityNames(List<String> entityNames) {
            this.entityNames = entityNames;
            this.changedFields = changedFields.add("EntityNames");
            return this;
        }

        public Builder entityNames(String... entityNames) {
            return entityNames(Arrays.asList(entityNames));
        }

        public Builder entityNamesNextLink(String entityNamesNextLink) {
            this.entityNamesNextLink = entityNamesNextLink;
            this.changedFields = changedFields.add("EntityNames");
            return this;
        }

        public GetValidManyToManyResponse build() {
            GetValidManyToManyResponse _x = new GetValidManyToManyResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.GetValidManyToManyResponse";
            _x.entityNames = entityNames;
            _x.entityNamesNextLink = entityNamesNextLink;
            return _x;
        }
    }

    private GetValidManyToManyResponse _copy() {
        GetValidManyToManyResponse _x = new GetValidManyToManyResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.entityNames = entityNames;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GetValidManyToManyResponse[");
        b.append("EntityNames=");
        b.append(this.entityNames);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
