package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import microsoft.dynamics.crm.enums.LogicalOperator;
import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "FilterOperator", 
    "FilterHint", 
    "Conditions", 
    "Filters", 
    "IsQuickFindFilter"})
@JsonInclude(Include.NON_NULL)
public class FilterExpression implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("FilterOperator")
    protected LogicalOperator filterOperator;

    @JsonProperty("FilterHint")
    protected String filterHint;

    @JsonProperty("Conditions")
    protected List<ConditionExpression> conditions;

    @JsonProperty("Conditions@nextLink")
    protected String conditionsNextLink;

    @JsonProperty("Filters")
    protected List<FilterExpression> filters;

    @JsonProperty("Filters@nextLink")
    protected String filtersNextLink;

    @JsonProperty("IsQuickFindFilter")
    protected Boolean isQuickFindFilter;

    protected FilterExpression() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.FilterExpression";
    }

    @Property(name="FilterOperator")
    @JsonIgnore
    public Optional<LogicalOperator> getFilterOperator() {
        return Optional.ofNullable(filterOperator);
    }

    public FilterExpression withFilterOperator(LogicalOperator filterOperator) {
        FilterExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.FilterExpression");
        _x.filterOperator = filterOperator;
        return _x;
    }

    @Property(name="FilterHint")
    @JsonIgnore
    public Optional<String> getFilterHint() {
        return Optional.ofNullable(filterHint);
    }

    public FilterExpression withFilterHint(String filterHint) {
        Checks.checkIsAscii(filterHint);
        FilterExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.FilterExpression");
        _x.filterHint = filterHint;
        return _x;
    }

    @Property(name="Conditions")
    @JsonIgnore
    public CollectionPage<ConditionExpression> getConditions() {
        return new CollectionPage<ConditionExpression>(contextPath, ConditionExpression.class, this.conditions, Optional.ofNullable(conditionsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Conditions")
    @JsonIgnore
    public CollectionPage<ConditionExpression> getConditions(HttpRequestOptions options) {
        return new CollectionPage<ConditionExpression>(contextPath, ConditionExpression.class, this.conditions, Optional.ofNullable(conditionsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="Filters")
    @JsonIgnore
    public CollectionPage<FilterExpression> getFilters() {
        return new CollectionPage<FilterExpression>(contextPath, FilterExpression.class, this.filters, Optional.ofNullable(filtersNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Filters")
    @JsonIgnore
    public CollectionPage<FilterExpression> getFilters(HttpRequestOptions options) {
        return new CollectionPage<FilterExpression>(contextPath, FilterExpression.class, this.filters, Optional.ofNullable(filtersNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="IsQuickFindFilter")
    @JsonIgnore
    public Optional<Boolean> getIsQuickFindFilter() {
        return Optional.ofNullable(isQuickFindFilter);
    }

    public FilterExpression withIsQuickFindFilter(Boolean isQuickFindFilter) {
        FilterExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.FilterExpression");
        _x.isQuickFindFilter = isQuickFindFilter;
        return _x;
    }

    public FilterExpression withUnmappedField(String name, String value) {
        FilterExpression _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private LogicalOperator filterOperator;
        private String filterHint;
        private List<ConditionExpression> conditions;
        private String conditionsNextLink;
        private List<FilterExpression> filters;
        private String filtersNextLink;
        private Boolean isQuickFindFilter;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder filterOperator(LogicalOperator filterOperator) {
            this.filterOperator = filterOperator;
            this.changedFields = changedFields.add("FilterOperator");
            return this;
        }

        public Builder filterHint(String filterHint) {
            this.filterHint = filterHint;
            this.changedFields = changedFields.add("FilterHint");
            return this;
        }

        public Builder conditions(List<ConditionExpression> conditions) {
            this.conditions = conditions;
            this.changedFields = changedFields.add("Conditions");
            return this;
        }

        public Builder conditions(ConditionExpression... conditions) {
            return conditions(Arrays.asList(conditions));
        }

        public Builder conditionsNextLink(String conditionsNextLink) {
            this.conditionsNextLink = conditionsNextLink;
            this.changedFields = changedFields.add("Conditions");
            return this;
        }

        public Builder filters(List<FilterExpression> filters) {
            this.filters = filters;
            this.changedFields = changedFields.add("Filters");
            return this;
        }

        public Builder filters(FilterExpression... filters) {
            return filters(Arrays.asList(filters));
        }

        public Builder filtersNextLink(String filtersNextLink) {
            this.filtersNextLink = filtersNextLink;
            this.changedFields = changedFields.add("Filters");
            return this;
        }

        public Builder isQuickFindFilter(Boolean isQuickFindFilter) {
            this.isQuickFindFilter = isQuickFindFilter;
            this.changedFields = changedFields.add("IsQuickFindFilter");
            return this;
        }

        public FilterExpression build() {
            FilterExpression _x = new FilterExpression();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.FilterExpression";
            _x.filterOperator = filterOperator;
            _x.filterHint = filterHint;
            _x.conditions = conditions;
            _x.conditionsNextLink = conditionsNextLink;
            _x.filters = filters;
            _x.filtersNextLink = filtersNextLink;
            _x.isQuickFindFilter = isQuickFindFilter;
            return _x;
        }
    }

    private FilterExpression _copy() {
        FilterExpression _x = new FilterExpression();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.filterOperator = filterOperator;
        _x.filterHint = filterHint;
        _x.conditions = conditions;
        _x.filters = filters;
        _x.isQuickFindFilter = isQuickFindFilter;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("FilterExpression[");
        b.append("FilterOperator=");
        b.append(this.filterOperator);
        b.append(", ");
        b.append("FilterHint=");
        b.append(this.filterHint);
        b.append(", ");
        b.append("Conditions=");
        b.append(this.conditions);
        b.append(", ");
        b.append("Filters=");
        b.append(this.filters);
        b.append(", ");
        b.append("IsQuickFindFilter=");
        b.append(this.isQuickFindFilter);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
