package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "DependentRelationships"})
@JsonInclude(Include.NON_NULL)
public class DependentRelationshipCollection implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("DependentRelationships")
    protected List<DependentRelationship> dependentRelationships;

    @JsonProperty("DependentRelationships@nextLink")
    protected String dependentRelationshipsNextLink;

    protected DependentRelationshipCollection() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.DependentRelationshipCollection";
    }

    @Property(name="DependentRelationships")
    @JsonIgnore
    public CollectionPage<DependentRelationship> getDependentRelationships() {
        return new CollectionPage<DependentRelationship>(contextPath, DependentRelationship.class, this.dependentRelationships, Optional.ofNullable(dependentRelationshipsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="DependentRelationships")
    @JsonIgnore
    public CollectionPage<DependentRelationship> getDependentRelationships(HttpRequestOptions options) {
        return new CollectionPage<DependentRelationship>(contextPath, DependentRelationship.class, this.dependentRelationships, Optional.ofNullable(dependentRelationshipsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    public DependentRelationshipCollection withUnmappedField(String name, String value) {
        DependentRelationshipCollection _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<DependentRelationship> dependentRelationships;
        private String dependentRelationshipsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder dependentRelationships(List<DependentRelationship> dependentRelationships) {
            this.dependentRelationships = dependentRelationships;
            this.changedFields = changedFields.add("DependentRelationships");
            return this;
        }

        public Builder dependentRelationships(DependentRelationship... dependentRelationships) {
            return dependentRelationships(Arrays.asList(dependentRelationships));
        }

        public Builder dependentRelationshipsNextLink(String dependentRelationshipsNextLink) {
            this.dependentRelationshipsNextLink = dependentRelationshipsNextLink;
            this.changedFields = changedFields.add("DependentRelationships");
            return this;
        }

        public DependentRelationshipCollection build() {
            DependentRelationshipCollection _x = new DependentRelationshipCollection();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.DependentRelationshipCollection";
            _x.dependentRelationships = dependentRelationships;
            _x.dependentRelationshipsNextLink = dependentRelationshipsNextLink;
            return _x;
        }
    }

    private DependentRelationshipCollection _copy() {
        DependentRelationshipCollection _x = new DependentRelationshipCollection();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.dependentRelationships = dependentRelationships;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DependentRelationshipCollection[");
        b.append("DependentRelationships=");
        b.append(this.dependentRelationships);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
