package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "Entities", 
    "RelationshipNavigationEntities", 
    "OtherMetadata"})
@JsonInclude(Include.NON_NULL)
public class ClientMetadataResults implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Entities")
    protected List<ClientEntityMetadata> entities;

    @JsonProperty("Entities@nextLink")
    protected String entitiesNextLink;

    @JsonProperty("RelationshipNavigationEntities")
    protected List<ClientEntityMetadata> relationshipNavigationEntities;

    @JsonProperty("RelationshipNavigationEntities@nextLink")
    protected String relationshipNavigationEntitiesNextLink;

    @JsonProperty("OtherMetadata")
    protected String otherMetadata;

    protected ClientMetadataResults() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ClientMetadataResults";
    }

    @Property(name="Entities")
    @JsonIgnore
    public CollectionPage<ClientEntityMetadata> getEntities() {
        return new CollectionPage<ClientEntityMetadata>(contextPath, ClientEntityMetadata.class, this.entities, Optional.ofNullable(entitiesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Entities")
    @JsonIgnore
    public CollectionPage<ClientEntityMetadata> getEntities(HttpRequestOptions options) {
        return new CollectionPage<ClientEntityMetadata>(contextPath, ClientEntityMetadata.class, this.entities, Optional.ofNullable(entitiesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="RelationshipNavigationEntities")
    @JsonIgnore
    public CollectionPage<ClientEntityMetadata> getRelationshipNavigationEntities() {
        return new CollectionPage<ClientEntityMetadata>(contextPath, ClientEntityMetadata.class, this.relationshipNavigationEntities, Optional.ofNullable(relationshipNavigationEntitiesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="RelationshipNavigationEntities")
    @JsonIgnore
    public CollectionPage<ClientEntityMetadata> getRelationshipNavigationEntities(HttpRequestOptions options) {
        return new CollectionPage<ClientEntityMetadata>(contextPath, ClientEntityMetadata.class, this.relationshipNavigationEntities, Optional.ofNullable(relationshipNavigationEntitiesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="OtherMetadata")
    @JsonIgnore
    public Optional<String> getOtherMetadata() {
        return Optional.ofNullable(otherMetadata);
    }

    public ClientMetadataResults withOtherMetadata(String otherMetadata) {
        Checks.checkIsAscii(otherMetadata);
        ClientMetadataResults _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ClientMetadataResults");
        _x.otherMetadata = otherMetadata;
        return _x;
    }

    public ClientMetadataResults withUnmappedField(String name, String value) {
        ClientMetadataResults _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<ClientEntityMetadata> entities;
        private String entitiesNextLink;
        private List<ClientEntityMetadata> relationshipNavigationEntities;
        private String relationshipNavigationEntitiesNextLink;
        private String otherMetadata;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder entities(List<ClientEntityMetadata> entities) {
            this.entities = entities;
            this.changedFields = changedFields.add("Entities");
            return this;
        }

        public Builder entities(ClientEntityMetadata... entities) {
            return entities(Arrays.asList(entities));
        }

        public Builder entitiesNextLink(String entitiesNextLink) {
            this.entitiesNextLink = entitiesNextLink;
            this.changedFields = changedFields.add("Entities");
            return this;
        }

        public Builder relationshipNavigationEntities(List<ClientEntityMetadata> relationshipNavigationEntities) {
            this.relationshipNavigationEntities = relationshipNavigationEntities;
            this.changedFields = changedFields.add("RelationshipNavigationEntities");
            return this;
        }

        public Builder relationshipNavigationEntities(ClientEntityMetadata... relationshipNavigationEntities) {
            return relationshipNavigationEntities(Arrays.asList(relationshipNavigationEntities));
        }

        public Builder relationshipNavigationEntitiesNextLink(String relationshipNavigationEntitiesNextLink) {
            this.relationshipNavigationEntitiesNextLink = relationshipNavigationEntitiesNextLink;
            this.changedFields = changedFields.add("RelationshipNavigationEntities");
            return this;
        }

        public Builder otherMetadata(String otherMetadata) {
            this.otherMetadata = otherMetadata;
            this.changedFields = changedFields.add("OtherMetadata");
            return this;
        }

        public ClientMetadataResults build() {
            ClientMetadataResults _x = new ClientMetadataResults();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ClientMetadataResults";
            _x.entities = entities;
            _x.entitiesNextLink = entitiesNextLink;
            _x.relationshipNavigationEntities = relationshipNavigationEntities;
            _x.relationshipNavigationEntitiesNextLink = relationshipNavigationEntitiesNextLink;
            _x.otherMetadata = otherMetadata;
            return _x;
        }
    }

    private ClientMetadataResults _copy() {
        ClientMetadataResults _x = new ClientMetadataResults();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.entities = entities;
        _x.relationshipNavigationEntities = relationshipNavigationEntities;
        _x.otherMetadata = otherMetadata;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ClientMetadataResults[");
        b.append("Entities=");
        b.append(this.entities);
        b.append(", ");
        b.append("RelationshipNavigationEntities=");
        b.append(this.relationshipNavigationEntities);
        b.append(", ");
        b.append("OtherMetadata=");
        b.append(this.otherMetadata);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
