package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "PartitionNumber", 
    "StartDate", 
    "EndDate", 
    "Size"})
@JsonInclude(Include.NON_NULL)
public class AuditPartitionDetail implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("PartitionNumber")
    protected Integer partitionNumber;

    @JsonProperty("StartDate")
    protected OffsetDateTime startDate;

    @JsonProperty("EndDate")
    protected OffsetDateTime endDate;

    @JsonProperty("Size")
    protected Long size;

    protected AuditPartitionDetail() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.AuditPartitionDetail";
    }

    @Property(name="PartitionNumber")
    @JsonIgnore
    public Optional<Integer> getPartitionNumber() {
        return Optional.ofNullable(partitionNumber);
    }

    public AuditPartitionDetail withPartitionNumber(Integer partitionNumber) {
        AuditPartitionDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AuditPartitionDetail");
        _x.partitionNumber = partitionNumber;
        return _x;
    }

    @Property(name="StartDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDate() {
        return Optional.ofNullable(startDate);
    }

    public AuditPartitionDetail withStartDate(OffsetDateTime startDate) {
        AuditPartitionDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AuditPartitionDetail");
        _x.startDate = startDate;
        return _x;
    }

    @Property(name="EndDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndDate() {
        return Optional.ofNullable(endDate);
    }

    public AuditPartitionDetail withEndDate(OffsetDateTime endDate) {
        AuditPartitionDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AuditPartitionDetail");
        _x.endDate = endDate;
        return _x;
    }

    @Property(name="Size")
    @JsonIgnore
    public Optional<Long> getSize() {
        return Optional.ofNullable(size);
    }

    public AuditPartitionDetail withSize(Long size) {
        AuditPartitionDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AuditPartitionDetail");
        _x.size = size;
        return _x;
    }

    public AuditPartitionDetail withUnmappedField(String name, String value) {
        AuditPartitionDetail _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer partitionNumber;
        private OffsetDateTime startDate;
        private OffsetDateTime endDate;
        private Long size;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder partitionNumber(Integer partitionNumber) {
            this.partitionNumber = partitionNumber;
            this.changedFields = changedFields.add("PartitionNumber");
            return this;
        }

        public Builder startDate(OffsetDateTime startDate) {
            this.startDate = startDate;
            this.changedFields = changedFields.add("StartDate");
            return this;
        }

        public Builder endDate(OffsetDateTime endDate) {
            this.endDate = endDate;
            this.changedFields = changedFields.add("EndDate");
            return this;
        }

        public Builder size(Long size) {
            this.size = size;
            this.changedFields = changedFields.add("Size");
            return this;
        }

        public AuditPartitionDetail build() {
            AuditPartitionDetail _x = new AuditPartitionDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.AuditPartitionDetail";
            _x.partitionNumber = partitionNumber;
            _x.startDate = startDate;
            _x.endDate = endDate;
            _x.size = size;
            return _x;
        }
    }

    private AuditPartitionDetail _copy() {
        AuditPartitionDetail _x = new AuditPartitionDetail();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.partitionNumber = partitionNumber;
        _x.startDate = startDate;
        _x.endDate = endDate;
        _x.size = size;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AuditPartitionDetail[");
        b.append("PartitionNumber=");
        b.append(this.partitionNumber);
        b.append(", ");
        b.append("StartDate=");
        b.append(this.startDate);
        b.append(", ");
        b.append("EndDate=");
        b.append(this.endDate);
        b.append(", ");
        b.append("Size=");
        b.append(this.size);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
