package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "InvalidNewValueAttributes", 
    "DeletedAttributes", 
    "LocLabelLanguageCode"})
@JsonInclude(Include.NON_NULL)
public class AttributeAuditDetail extends AuditDetail implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("InvalidNewValueAttributes")
    protected List<String> invalidNewValueAttributes;

    @JsonProperty("InvalidNewValueAttributes@nextLink")
    protected String invalidNewValueAttributesNextLink;

    @JsonProperty("DeletedAttributes")
    protected Collection_Int32_String deletedAttributes;

    @JsonProperty("LocLabelLanguageCode")
    protected Integer locLabelLanguageCode;

    protected AttributeAuditDetail() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.AttributeAuditDetail";
    }

    @Property(name="InvalidNewValueAttributes")
    @JsonIgnore
    public CollectionPage<String> getInvalidNewValueAttributes() {
        return new CollectionPage<String>(contextPath, String.class, this.invalidNewValueAttributes, Optional.ofNullable(invalidNewValueAttributesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="InvalidNewValueAttributes")
    @JsonIgnore
    public CollectionPage<String> getInvalidNewValueAttributes(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.invalidNewValueAttributes, Optional.ofNullable(invalidNewValueAttributesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="DeletedAttributes")
    @JsonIgnore
    public Optional<Collection_Int32_String> getDeletedAttributes() {
        return Optional.ofNullable(deletedAttributes);
    }

    public AttributeAuditDetail withDeletedAttributes(Collection_Int32_String deletedAttributes) {
        AttributeAuditDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeAuditDetail");
        _x.deletedAttributes = deletedAttributes;
        return _x;
    }

    @Property(name="LocLabelLanguageCode")
    @JsonIgnore
    public Optional<Integer> getLocLabelLanguageCode() {
        return Optional.ofNullable(locLabelLanguageCode);
    }

    public AttributeAuditDetail withLocLabelLanguageCode(Integer locLabelLanguageCode) {
        AttributeAuditDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeAuditDetail");
        _x.locLabelLanguageCode = locLabelLanguageCode;
        return _x;
    }

    public AttributeAuditDetail withUnmappedField(String name, String value) {
        AttributeAuditDetail _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAttributeAuditDetail() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> invalidNewValueAttributes;
        private String invalidNewValueAttributesNextLink;
        private Collection_Int32_String deletedAttributes;
        private Integer locLabelLanguageCode;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder invalidNewValueAttributes(List<String> invalidNewValueAttributes) {
            this.invalidNewValueAttributes = invalidNewValueAttributes;
            this.changedFields = changedFields.add("InvalidNewValueAttributes");
            return this;
        }

        public Builder invalidNewValueAttributes(String... invalidNewValueAttributes) {
            return invalidNewValueAttributes(Arrays.asList(invalidNewValueAttributes));
        }

        public Builder invalidNewValueAttributesNextLink(String invalidNewValueAttributesNextLink) {
            this.invalidNewValueAttributesNextLink = invalidNewValueAttributesNextLink;
            this.changedFields = changedFields.add("InvalidNewValueAttributes");
            return this;
        }

        public Builder deletedAttributes(Collection_Int32_String deletedAttributes) {
            this.deletedAttributes = deletedAttributes;
            this.changedFields = changedFields.add("DeletedAttributes");
            return this;
        }

        public Builder locLabelLanguageCode(Integer locLabelLanguageCode) {
            this.locLabelLanguageCode = locLabelLanguageCode;
            this.changedFields = changedFields.add("LocLabelLanguageCode");
            return this;
        }

        public AttributeAuditDetail build() {
            AttributeAuditDetail _x = new AttributeAuditDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.AttributeAuditDetail";
            _x.invalidNewValueAttributes = invalidNewValueAttributes;
            _x.invalidNewValueAttributesNextLink = invalidNewValueAttributesNextLink;
            _x.deletedAttributes = deletedAttributes;
            _x.locLabelLanguageCode = locLabelLanguageCode;
            return _x;
        }
    }

    private AttributeAuditDetail _copy() {
        AttributeAuditDetail _x = new AttributeAuditDetail();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.invalidNewValueAttributes = invalidNewValueAttributes;
        _x.deletedAttributes = deletedAttributes;
        _x.locLabelLanguageCode = locLabelLanguageCode;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AttributeAuditDetail[");
        b.append("InvalidNewValueAttributes=");
        b.append(this.invalidNewValueAttributes);
        b.append(", ");
        b.append("DeletedAttributes=");
        b.append(this.deletedAttributes);
        b.append(", ");
        b.append("LocLabelLanguageCode=");
        b.append(this.locLabelLanguageCode);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
