package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "AppElements"})
@JsonInclude(Include.NON_NULL)
public class AppModuleSaveResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("AppElements")
    protected List<AppElementInfo> appElements;

    @JsonProperty("AppElements@nextLink")
    protected String appElementsNextLink;

    protected AppModuleSaveResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.AppModuleSaveResponse";
    }

    @Property(name="AppElements")
    @JsonIgnore
    public CollectionPage<AppElementInfo> getAppElements() {
        return new CollectionPage<AppElementInfo>(contextPath, AppElementInfo.class, this.appElements, Optional.ofNullable(appElementsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="AppElements")
    @JsonIgnore
    public CollectionPage<AppElementInfo> getAppElements(HttpRequestOptions options) {
        return new CollectionPage<AppElementInfo>(contextPath, AppElementInfo.class, this.appElements, Optional.ofNullable(appElementsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    public AppModuleSaveResponse withUnmappedField(String name, String value) {
        AppModuleSaveResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<AppElementInfo> appElements;
        private String appElementsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder appElements(List<AppElementInfo> appElements) {
            this.appElements = appElements;
            this.changedFields = changedFields.add("AppElements");
            return this;
        }

        public Builder appElements(AppElementInfo... appElements) {
            return appElements(Arrays.asList(appElements));
        }

        public Builder appElementsNextLink(String appElementsNextLink) {
            this.appElementsNextLink = appElementsNextLink;
            this.changedFields = changedFields.add("AppElements");
            return this;
        }

        public AppModuleSaveResponse build() {
            AppModuleSaveResponse _x = new AppModuleSaveResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.AppModuleSaveResponse";
            _x.appElements = appElements;
            _x.appElementsNextLink = appElementsNextLink;
            return _x;
        }
    }

    private AppModuleSaveResponse _copy() {
        AppModuleSaveResponse _x = new AppModuleSaveResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.appElements = appElements;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppModuleSaveResponse[");
        b.append("AppElements=");
        b.append(this.appElements);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
