package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "AppId", 
    "Title", 
    "UniqueName", 
    "IsDefault", 
    "Description", 
    "webResourceInfo", 
    "welcomePageInfo", 
    "Status", 
    "LastModifiedOn", 
    "AppUrl", 
    "ClientType", 
    "MobileOfflineProfileIds"})
@JsonInclude(Include.NON_NULL)
public class AppInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("AppId")
    protected String appId;

    @JsonProperty("Title")
    protected String title;

    @JsonProperty("UniqueName")
    protected String uniqueName;

    @JsonProperty("IsDefault")
    protected Boolean isDefault;

    @JsonProperty("Description")
    protected String description;

    @JsonProperty("webResourceInfo")
    protected WebResourceInfo webResourceInfo;

    @JsonProperty("welcomePageInfo")
    protected WebResourceInfo welcomePageInfo;

    @JsonProperty("Status")
    protected Integer status;

    @JsonProperty("LastModifiedOn")
    protected String lastModifiedOn;

    @JsonProperty("AppUrl")
    protected String appUrl;

    @JsonProperty("ClientType")
    protected Integer clientType;

    @JsonProperty("MobileOfflineProfileIds")
    protected List<String> mobileOfflineProfileIds;

    @JsonProperty("MobileOfflineProfileIds@nextLink")
    protected String mobileOfflineProfileIdsNextLink;

    protected AppInfo() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.AppInfo";
    }

    @Property(name="AppId")
    @JsonIgnore
    public Optional<String> getAppId() {
        return Optional.ofNullable(appId);
    }

    public AppInfo withAppId(String appId) {
        Checks.checkIsAscii(appId);
        AppInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AppInfo");
        _x.appId = appId;
        return _x;
    }

    @Property(name="Title")
    @JsonIgnore
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    public AppInfo withTitle(String title) {
        Checks.checkIsAscii(title);
        AppInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AppInfo");
        _x.title = title;
        return _x;
    }

    @Property(name="UniqueName")
    @JsonIgnore
    public Optional<String> getUniqueName() {
        return Optional.ofNullable(uniqueName);
    }

    public AppInfo withUniqueName(String uniqueName) {
        Checks.checkIsAscii(uniqueName);
        AppInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AppInfo");
        _x.uniqueName = uniqueName;
        return _x;
    }

    @Property(name="IsDefault")
    @JsonIgnore
    public Optional<Boolean> getIsDefault() {
        return Optional.ofNullable(isDefault);
    }

    public AppInfo withIsDefault(Boolean isDefault) {
        AppInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AppInfo");
        _x.isDefault = isDefault;
        return _x;
    }

    @Property(name="Description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public AppInfo withDescription(String description) {
        Checks.checkIsAscii(description);
        AppInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AppInfo");
        _x.description = description;
        return _x;
    }

    @Property(name="webResourceInfo")
    @JsonIgnore
    public Optional<WebResourceInfo> getWebResourceInfo() {
        return Optional.ofNullable(webResourceInfo);
    }

    public AppInfo withWebResourceInfo(WebResourceInfo webResourceInfo) {
        AppInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AppInfo");
        _x.webResourceInfo = webResourceInfo;
        return _x;
    }

    @Property(name="welcomePageInfo")
    @JsonIgnore
    public Optional<WebResourceInfo> getWelcomePageInfo() {
        return Optional.ofNullable(welcomePageInfo);
    }

    public AppInfo withWelcomePageInfo(WebResourceInfo welcomePageInfo) {
        AppInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AppInfo");
        _x.welcomePageInfo = welcomePageInfo;
        return _x;
    }

    @Property(name="Status")
    @JsonIgnore
    public Optional<Integer> getStatus() {
        return Optional.ofNullable(status);
    }

    public AppInfo withStatus(Integer status) {
        AppInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AppInfo");
        _x.status = status;
        return _x;
    }

    @Property(name="LastModifiedOn")
    @JsonIgnore
    public Optional<String> getLastModifiedOn() {
        return Optional.ofNullable(lastModifiedOn);
    }

    public AppInfo withLastModifiedOn(String lastModifiedOn) {
        Checks.checkIsAscii(lastModifiedOn);
        AppInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AppInfo");
        _x.lastModifiedOn = lastModifiedOn;
        return _x;
    }

    @Property(name="AppUrl")
    @JsonIgnore
    public Optional<String> getAppUrl() {
        return Optional.ofNullable(appUrl);
    }

    public AppInfo withAppUrl(String appUrl) {
        Checks.checkIsAscii(appUrl);
        AppInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AppInfo");
        _x.appUrl = appUrl;
        return _x;
    }

    @Property(name="ClientType")
    @JsonIgnore
    public Optional<Integer> getClientType() {
        return Optional.ofNullable(clientType);
    }

    public AppInfo withClientType(Integer clientType) {
        AppInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AppInfo");
        _x.clientType = clientType;
        return _x;
    }

    @Property(name="MobileOfflineProfileIds")
    @JsonIgnore
    public CollectionPage<String> getMobileOfflineProfileIds() {
        return new CollectionPage<String>(contextPath, String.class, this.mobileOfflineProfileIds, Optional.ofNullable(mobileOfflineProfileIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="MobileOfflineProfileIds")
    @JsonIgnore
    public CollectionPage<String> getMobileOfflineProfileIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.mobileOfflineProfileIds, Optional.ofNullable(mobileOfflineProfileIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    public AppInfo withUnmappedField(String name, String value) {
        AppInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String appId;
        private String title;
        private String uniqueName;
        private Boolean isDefault;
        private String description;
        private WebResourceInfo webResourceInfo;
        private WebResourceInfo welcomePageInfo;
        private Integer status;
        private String lastModifiedOn;
        private String appUrl;
        private Integer clientType;
        private List<String> mobileOfflineProfileIds;
        private String mobileOfflineProfileIdsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder appId(String appId) {
            this.appId = appId;
            this.changedFields = changedFields.add("AppId");
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            this.changedFields = changedFields.add("Title");
            return this;
        }

        public Builder uniqueName(String uniqueName) {
            this.uniqueName = uniqueName;
            this.changedFields = changedFields.add("UniqueName");
            return this;
        }

        public Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            this.changedFields = changedFields.add("IsDefault");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("Description");
            return this;
        }

        public Builder webResourceInfo(WebResourceInfo webResourceInfo) {
            this.webResourceInfo = webResourceInfo;
            this.changedFields = changedFields.add("webResourceInfo");
            return this;
        }

        public Builder welcomePageInfo(WebResourceInfo welcomePageInfo) {
            this.welcomePageInfo = welcomePageInfo;
            this.changedFields = changedFields.add("welcomePageInfo");
            return this;
        }

        public Builder status(Integer status) {
            this.status = status;
            this.changedFields = changedFields.add("Status");
            return this;
        }

        public Builder lastModifiedOn(String lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
            this.changedFields = changedFields.add("LastModifiedOn");
            return this;
        }

        public Builder appUrl(String appUrl) {
            this.appUrl = appUrl;
            this.changedFields = changedFields.add("AppUrl");
            return this;
        }

        public Builder clientType(Integer clientType) {
            this.clientType = clientType;
            this.changedFields = changedFields.add("ClientType");
            return this;
        }

        public Builder mobileOfflineProfileIds(List<String> mobileOfflineProfileIds) {
            this.mobileOfflineProfileIds = mobileOfflineProfileIds;
            this.changedFields = changedFields.add("MobileOfflineProfileIds");
            return this;
        }

        public Builder mobileOfflineProfileIds(String... mobileOfflineProfileIds) {
            return mobileOfflineProfileIds(Arrays.asList(mobileOfflineProfileIds));
        }

        public Builder mobileOfflineProfileIdsNextLink(String mobileOfflineProfileIdsNextLink) {
            this.mobileOfflineProfileIdsNextLink = mobileOfflineProfileIdsNextLink;
            this.changedFields = changedFields.add("MobileOfflineProfileIds");
            return this;
        }

        public AppInfo build() {
            AppInfo _x = new AppInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.AppInfo";
            _x.appId = appId;
            _x.title = title;
            _x.uniqueName = uniqueName;
            _x.isDefault = isDefault;
            _x.description = description;
            _x.webResourceInfo = webResourceInfo;
            _x.welcomePageInfo = welcomePageInfo;
            _x.status = status;
            _x.lastModifiedOn = lastModifiedOn;
            _x.appUrl = appUrl;
            _x.clientType = clientType;
            _x.mobileOfflineProfileIds = mobileOfflineProfileIds;
            _x.mobileOfflineProfileIdsNextLink = mobileOfflineProfileIdsNextLink;
            return _x;
        }
    }

    private AppInfo _copy() {
        AppInfo _x = new AppInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.appId = appId;
        _x.title = title;
        _x.uniqueName = uniqueName;
        _x.isDefault = isDefault;
        _x.description = description;
        _x.webResourceInfo = webResourceInfo;
        _x.welcomePageInfo = welcomePageInfo;
        _x.status = status;
        _x.lastModifiedOn = lastModifiedOn;
        _x.appUrl = appUrl;
        _x.clientType = clientType;
        _x.mobileOfflineProfileIds = mobileOfflineProfileIds;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppInfo[");
        b.append("AppId=");
        b.append(this.appId);
        b.append(", ");
        b.append("Title=");
        b.append(this.title);
        b.append(", ");
        b.append("UniqueName=");
        b.append(this.uniqueName);
        b.append(", ");
        b.append("IsDefault=");
        b.append(this.isDefault);
        b.append(", ");
        b.append("Description=");
        b.append(this.description);
        b.append(", ");
        b.append("webResourceInfo=");
        b.append(this.webResourceInfo);
        b.append(", ");
        b.append("welcomePageInfo=");
        b.append(this.welcomePageInfo);
        b.append(", ");
        b.append("Status=");
        b.append(this.status);
        b.append(", ");
        b.append("LastModifiedOn=");
        b.append(this.lastModifiedOn);
        b.append(", ");
        b.append("AppUrl=");
        b.append(this.appUrl);
        b.append(", ");
        b.append("ClientType=");
        b.append(this.clientType);
        b.append(", ");
        b.append("MobileOfflineProfileIds=");
        b.append(this.mobileOfflineProfileIds);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
