/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import java.util.Map;
import java.util.Optional;
import microsoft.dynamics.crm.entity.Systemform;
import microsoft.dynamics.crm.entity.Systemuser;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesstriggerCollectionRequest;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.ProcesstriggerRequest;
import microsoft.dynamics.crm.entity.request.SystemformRequest;
import microsoft.dynamics.crm.schema.SchemaInfo;

public class SystemformCollectionRequest
extends CollectionPageEntityRequest<Systemform, SystemformRequest> {
    protected ContextPath contextPath;

    public SystemformCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Systemform.class, cp -> new SystemformRequest(cp, Optional.empty()), (com.github.davidmoten.odata.client.SchemaInfo)SchemaInfo.INSTANCE, value);
        this.contextPath = contextPath;
    }

    public AsyncoperationCollectionRequest systemForm_AsyncOperations() {
        return new AsyncoperationCollectionRequest(this.contextPath.addSegment("SystemForm_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest systemForm_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(this.contextPath.addSegment("SystemForm_AsyncOperations").addKeys(new NameValue[]{new NameValue(asyncoperationid.toString())}), Optional.empty());
    }

    public ProcesstriggerCollectionRequest processtrigger_systemform() {
        return new ProcesstriggerCollectionRequest(this.contextPath.addSegment("processtrigger_systemform"), Optional.empty());
    }

    public ProcesstriggerRequest processtrigger_systemform(String processtriggerid) {
        return new ProcesstriggerRequest(this.contextPath.addSegment("processtrigger_systemform").addKeys(new NameValue[]{new NameValue(processtriggerid.toString())}), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest systemForm_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(this.contextPath.addSegment("SystemForm_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest systemForm_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(this.contextPath.addSegment("SystemForm_BulkDeleteFailures").addKeys(new NameValue[]{new NameValue(bulkdeletefailureid.toString())}), Optional.empty());
    }

    public SystemformCollectionRequest form_ancestor_form() {
        return new SystemformCollectionRequest(this.contextPath.addSegment("form_ancestor_form"), Optional.empty());
    }

    public SystemformRequest form_ancestor_form(String formid) {
        return new SystemformRequest(this.contextPath.addSegment("form_ancestor_form").addKeys(new NameValue[]{new NameValue(formid.toString())}), Optional.empty());
    }

    @Function(name="RetrieveFilteredForms")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Systemform> retrieveFilteredForms(String entityLogicalName, Integer formType, Systemuser user) {
        Preconditions.checkNotNull((Object)entityLogicalName, (String)"entityLogicalName cannot be null");
        Preconditions.checkNotNull((Object)formType, (String)"formType cannot be null");
        Preconditions.checkNotNull((Object)user, (String)"user cannot be null");
        Map _parameters = ParameterMap.put((String)"EntityLogicalName", (String)"Edm.String", (Object)Checks.checkIsAscii((String)entityLogicalName)).put("FormType", "Edm.Int32", (Object)formType).put("User", "Microsoft.Dynamics.CRM.systemuser", (Object)user).build();
        return CollectionPageNonEntityRequest.forFunction((ContextPath)this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveFilteredForms"), Systemform.class, (Map)_parameters, (com.github.davidmoten.odata.client.SchemaInfo)SchemaInfo.INSTANCE);
    }

    @Function(name="RetrieveUnpublishedMultiple")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Systemform> retrieveUnpublishedMultiple() {
        Map _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction((ContextPath)this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveUnpublishedMultiple"), Systemform.class, (Map)_parameters, (com.github.davidmoten.odata.client.SchemaInfo)SchemaInfo.INSTANCE);
    }
}

