/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import java.util.Optional;
import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.entity.MetadataBase;
import microsoft.dynamics.crm.enums.RelationshipType;
import microsoft.dynamics.crm.enums.SecurityTypes;

@JsonPropertyOrder(value={"@odata.type", "IsCustomRelationship", "IsCustomizable", "IsValidForAdvancedFind", "SchemaName", "SecurityTypes", "IsManaged", "RelationshipType", "IntroducedVersion"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RelationshipMetadataBase
extends MetadataBase
implements ODataEntityType {
    @JsonProperty(value="IsCustomRelationship")
    protected Boolean isCustomRelationship;
    @JsonProperty(value="IsCustomizable")
    protected BooleanManagedProperty isCustomizable;
    @JsonProperty(value="IsValidForAdvancedFind")
    protected Boolean isValidForAdvancedFind;
    @JsonProperty(value="SchemaName")
    protected String schemaName;
    @JsonProperty(value="SecurityTypes")
    protected SecurityTypes securityTypes;
    @JsonProperty(value="IsManaged")
    protected Boolean isManaged;
    @JsonProperty(value="RelationshipType")
    protected RelationshipType relationshipType;
    @JsonProperty(value="IntroducedVersion")
    protected String introducedVersion;

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.RelationshipMetadataBase";
    }

    protected RelationshipMetadataBase() {
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return this.changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && this.metadataId != null) {
            this.contextPath = this.contextPath.clearQueries().addKeys(new NameValue[]{new NameValue(this.metadataId.toString())});
        }
    }

    @Property(name="IsCustomRelationship")
    @JsonIgnore
    public Optional<Boolean> getIsCustomRelationship() {
        return Optional.ofNullable(this.isCustomRelationship);
    }

    public RelationshipMetadataBase withIsCustomRelationship(Boolean isCustomRelationship) {
        RelationshipMetadataBase _x = this._copy();
        _x.changedFields = this.changedFields.add("IsCustomRelationship");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.RelationshipMetadataBase");
        _x.isCustomRelationship = isCustomRelationship;
        return _x;
    }

    @Property(name="IsCustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsCustomizable() {
        return Optional.ofNullable(this.isCustomizable);
    }

    public RelationshipMetadataBase withIsCustomizable(BooleanManagedProperty isCustomizable) {
        RelationshipMetadataBase _x = this._copy();
        _x.changedFields = this.changedFields.add("IsCustomizable");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.RelationshipMetadataBase");
        _x.isCustomizable = isCustomizable;
        return _x;
    }

    @Property(name="IsValidForAdvancedFind")
    @JsonIgnore
    public Optional<Boolean> getIsValidForAdvancedFind() {
        return Optional.ofNullable(this.isValidForAdvancedFind);
    }

    public RelationshipMetadataBase withIsValidForAdvancedFind(Boolean isValidForAdvancedFind) {
        RelationshipMetadataBase _x = this._copy();
        _x.changedFields = this.changedFields.add("IsValidForAdvancedFind");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.RelationshipMetadataBase");
        _x.isValidForAdvancedFind = isValidForAdvancedFind;
        return _x;
    }

    @Property(name="SchemaName")
    @JsonIgnore
    public Optional<String> getSchemaName() {
        return Optional.ofNullable(this.schemaName);
    }

    public RelationshipMetadataBase withSchemaName(String schemaName) {
        Checks.checkIsAscii((String)schemaName);
        RelationshipMetadataBase _x = this._copy();
        _x.changedFields = this.changedFields.add("SchemaName");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.RelationshipMetadataBase");
        _x.schemaName = schemaName;
        return _x;
    }

    @Property(name="SecurityTypes")
    @JsonIgnore
    public Optional<SecurityTypes> getSecurityTypes() {
        return Optional.ofNullable(this.securityTypes);
    }

    public RelationshipMetadataBase withSecurityTypes(SecurityTypes securityTypes) {
        RelationshipMetadataBase _x = this._copy();
        _x.changedFields = this.changedFields.add("SecurityTypes");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.RelationshipMetadataBase");
        _x.securityTypes = securityTypes;
        return _x;
    }

    @Property(name="IsManaged")
    @JsonIgnore
    public Optional<Boolean> getIsManaged() {
        return Optional.ofNullable(this.isManaged);
    }

    public RelationshipMetadataBase withIsManaged(Boolean isManaged) {
        RelationshipMetadataBase _x = this._copy();
        _x.changedFields = this.changedFields.add("IsManaged");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.RelationshipMetadataBase");
        _x.isManaged = isManaged;
        return _x;
    }

    @Property(name="RelationshipType")
    @JsonIgnore
    public Optional<RelationshipType> getRelationshipType() {
        return Optional.ofNullable(this.relationshipType);
    }

    public RelationshipMetadataBase withRelationshipType(RelationshipType relationshipType) {
        RelationshipMetadataBase _x = this._copy();
        _x.changedFields = this.changedFields.add("RelationshipType");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.RelationshipMetadataBase");
        _x.relationshipType = relationshipType;
        return _x;
    }

    @Property(name="IntroducedVersion")
    @JsonIgnore
    public Optional<String> getIntroducedVersion() {
        return Optional.ofNullable(this.introducedVersion);
    }

    public RelationshipMetadataBase withIntroducedVersion(String introducedVersion) {
        Checks.checkIsAscii((String)introducedVersion);
        RelationshipMetadataBase _x = this._copy();
        _x.changedFields = this.changedFields.add("IntroducedVersion");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.RelationshipMetadataBase");
        _x.introducedVersion = introducedVersion;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFields();
        }
        this.unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields == null ? UnmappedFields.EMPTY : this.unmappedFields;
    }

    @Override
    public RelationshipMetadataBase patch() {
        RequestHelper.patch((ODataEntityType)this, (ContextPath)this.contextPath, (RequestOptions)RequestOptions.EMPTY);
        RelationshipMetadataBase _x = this._copy();
        _x.changedFields = null;
        return _x;
    }

    @Override
    public RelationshipMetadataBase put() {
        RequestHelper.put((ODataEntityType)this, (ContextPath)this.contextPath, (RequestOptions)RequestOptions.EMPTY);
        RelationshipMetadataBase _x = this._copy();
        _x.changedFields = null;
        return _x;
    }

    private RelationshipMetadataBase _copy() {
        RelationshipMetadataBase _x = new RelationshipMetadataBase();
        _x.contextPath = this.contextPath;
        _x.changedFields = this.changedFields;
        _x.unmappedFields = this.unmappedFields;
        _x.odataType = this.odataType;
        _x.metadataId = this.metadataId;
        _x.hasChanged = this.hasChanged;
        _x.isCustomRelationship = this.isCustomRelationship;
        _x.isCustomizable = this.isCustomizable;
        _x.isValidForAdvancedFind = this.isValidForAdvancedFind;
        _x.schemaName = this.schemaName;
        _x.securityTypes = this.securityTypes;
        _x.isManaged = this.isManaged;
        _x.relationshipType = this.relationshipType;
        _x.introducedVersion = this.introducedVersion;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RelationshipMetadataBase[");
        b.append("MetadataId=");
        b.append(this.metadataId);
        b.append(", ");
        b.append("HasChanged=");
        b.append(this.hasChanged);
        b.append(", ");
        b.append("IsCustomRelationship=");
        b.append(this.isCustomRelationship);
        b.append(", ");
        b.append("IsCustomizable=");
        b.append(this.isCustomizable);
        b.append(", ");
        b.append("IsValidForAdvancedFind=");
        b.append(this.isValidForAdvancedFind);
        b.append(", ");
        b.append("SchemaName=");
        b.append(this.schemaName);
        b.append(", ");
        b.append("SecurityTypes=");
        b.append((Object)this.securityTypes);
        b.append(", ");
        b.append("IsManaged=");
        b.append(this.isManaged);
        b.append(", ");
        b.append("RelationshipType=");
        b.append((Object)this.relationshipType);
        b.append(", ");
        b.append("IntroducedVersion=");
        b.append(this.introducedVersion);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }
}

