/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import java.util.Optional;
import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.complex.Label;
import microsoft.dynamics.crm.complex.OptionMetadata;
import microsoft.dynamics.crm.entity.OptionSetMetadataBase;
import microsoft.dynamics.crm.enums.OptionSetType;

@JsonPropertyOrder(value={"@odata.type", "TrueOption", "FalseOption"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BooleanOptionSetMetadata
extends OptionSetMetadataBase
implements ODataEntityType {
    @JsonProperty(value="TrueOption")
    protected OptionMetadata trueOption;
    @JsonProperty(value="FalseOption")
    protected OptionMetadata falseOption;

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.BooleanOptionSetMetadata";
    }

    protected BooleanOptionSetMetadata() {
    }

    public static Builder builderBooleanOptionSetMetadata() {
        return new Builder();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return this.changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && this.metadataId != null) {
            this.contextPath = this.contextPath.clearQueries().addKeys(new NameValue[]{new NameValue(this.metadataId.toString())});
        }
    }

    @Property(name="TrueOption")
    @JsonIgnore
    public Optional<OptionMetadata> getTrueOption() {
        return Optional.ofNullable(this.trueOption);
    }

    public BooleanOptionSetMetadata withTrueOption(OptionMetadata trueOption) {
        BooleanOptionSetMetadata _x = this._copy();
        _x.changedFields = this.changedFields.add("TrueOption");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.BooleanOptionSetMetadata");
        _x.trueOption = trueOption;
        return _x;
    }

    @Property(name="FalseOption")
    @JsonIgnore
    public Optional<OptionMetadata> getFalseOption() {
        return Optional.ofNullable(this.falseOption);
    }

    public BooleanOptionSetMetadata withFalseOption(OptionMetadata falseOption) {
        BooleanOptionSetMetadata _x = this._copy();
        _x.changedFields = this.changedFields.add("FalseOption");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.BooleanOptionSetMetadata");
        _x.falseOption = falseOption;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFields();
        }
        this.unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields == null ? UnmappedFields.EMPTY : this.unmappedFields;
    }

    @Override
    public BooleanOptionSetMetadata patch() {
        RequestHelper.patch((ODataEntityType)this, (ContextPath)this.contextPath, (RequestOptions)RequestOptions.EMPTY);
        BooleanOptionSetMetadata _x = this._copy();
        _x.changedFields = null;
        return _x;
    }

    @Override
    public BooleanOptionSetMetadata put() {
        RequestHelper.put((ODataEntityType)this, (ContextPath)this.contextPath, (RequestOptions)RequestOptions.EMPTY);
        BooleanOptionSetMetadata _x = this._copy();
        _x.changedFields = null;
        return _x;
    }

    private BooleanOptionSetMetadata _copy() {
        BooleanOptionSetMetadata _x = new BooleanOptionSetMetadata();
        _x.contextPath = this.contextPath;
        _x.changedFields = this.changedFields;
        _x.unmappedFields = this.unmappedFields;
        _x.odataType = this.odataType;
        _x.metadataId = this.metadataId;
        _x.hasChanged = this.hasChanged;
        _x.description = this.description;
        _x.displayName = this.displayName;
        _x.isCustomOptionSet = this.isCustomOptionSet;
        _x.isGlobal = this.isGlobal;
        _x.isManaged = this.isManaged;
        _x.isCustomizable = this.isCustomizable;
        _x.name = this.name;
        _x.externalTypeName = this.externalTypeName;
        _x.optionSetType = this.optionSetType;
        _x.introducedVersion = this.introducedVersion;
        _x.trueOption = this.trueOption;
        _x.falseOption = this.falseOption;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BooleanOptionSetMetadata[");
        b.append("MetadataId=");
        b.append(this.metadataId);
        b.append(", ");
        b.append("HasChanged=");
        b.append(this.hasChanged);
        b.append(", ");
        b.append("Description=");
        b.append(this.description);
        b.append(", ");
        b.append("DisplayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("IsCustomOptionSet=");
        b.append(this.isCustomOptionSet);
        b.append(", ");
        b.append("IsGlobal=");
        b.append(this.isGlobal);
        b.append(", ");
        b.append("IsManaged=");
        b.append(this.isManaged);
        b.append(", ");
        b.append("IsCustomizable=");
        b.append(this.isCustomizable);
        b.append(", ");
        b.append("Name=");
        b.append(this.name);
        b.append(", ");
        b.append("ExternalTypeName=");
        b.append(this.externalTypeName);
        b.append(", ");
        b.append("OptionSetType=");
        b.append((Object)this.optionSetType);
        b.append(", ");
        b.append("IntroducedVersion=");
        b.append(this.introducedVersion);
        b.append(", ");
        b.append("TrueOption=");
        b.append(this.trueOption);
        b.append(", ");
        b.append("FalseOption=");
        b.append(this.falseOption);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private String metadataId;
        private Boolean hasChanged;
        private Label description;
        private Label displayName;
        private Boolean isCustomOptionSet;
        private Boolean isGlobal;
        private Boolean isManaged;
        private BooleanManagedProperty isCustomizable;
        private String name;
        private String externalTypeName;
        private OptionSetType optionSetType;
        private String introducedVersion;
        private OptionMetadata trueOption;
        private OptionMetadata falseOption;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder metadataId(String metadataId) {
            this.metadataId = metadataId;
            this.changedFields = this.changedFields.add("MetadataId");
            return this;
        }

        public Builder hasChanged(Boolean hasChanged) {
            this.hasChanged = hasChanged;
            this.changedFields = this.changedFields.add("HasChanged");
            return this;
        }

        public Builder description(Label description) {
            this.description = description;
            this.changedFields = this.changedFields.add("Description");
            return this;
        }

        public Builder displayName(Label displayName) {
            this.displayName = displayName;
            this.changedFields = this.changedFields.add("DisplayName");
            return this;
        }

        public Builder isCustomOptionSet(Boolean isCustomOptionSet) {
            this.isCustomOptionSet = isCustomOptionSet;
            this.changedFields = this.changedFields.add("IsCustomOptionSet");
            return this;
        }

        public Builder isGlobal(Boolean isGlobal) {
            this.isGlobal = isGlobal;
            this.changedFields = this.changedFields.add("IsGlobal");
            return this;
        }

        public Builder isManaged(Boolean isManaged) {
            this.isManaged = isManaged;
            this.changedFields = this.changedFields.add("IsManaged");
            return this;
        }

        public Builder isCustomizable(BooleanManagedProperty isCustomizable) {
            this.isCustomizable = isCustomizable;
            this.changedFields = this.changedFields.add("IsCustomizable");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = this.changedFields.add("Name");
            return this;
        }

        public Builder externalTypeName(String externalTypeName) {
            this.externalTypeName = externalTypeName;
            this.changedFields = this.changedFields.add("ExternalTypeName");
            return this;
        }

        public Builder optionSetType(OptionSetType optionSetType) {
            this.optionSetType = optionSetType;
            this.changedFields = this.changedFields.add("OptionSetType");
            return this;
        }

        public Builder introducedVersion(String introducedVersion) {
            this.introducedVersion = introducedVersion;
            this.changedFields = this.changedFields.add("IntroducedVersion");
            return this;
        }

        public Builder trueOption(OptionMetadata trueOption) {
            this.trueOption = trueOption;
            this.changedFields = this.changedFields.add("TrueOption");
            return this;
        }

        public Builder falseOption(OptionMetadata falseOption) {
            this.falseOption = falseOption;
            this.changedFields = this.changedFields.add("FalseOption");
            return this;
        }

        public BooleanOptionSetMetadata build() {
            BooleanOptionSetMetadata _x = new BooleanOptionSetMetadata();
            _x.contextPath = null;
            _x.changedFields = this.changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "Microsoft.Dynamics.CRM.BooleanOptionSetMetadata";
            _x.metadataId = this.metadataId;
            _x.hasChanged = this.hasChanged;
            _x.description = this.description;
            _x.displayName = this.displayName;
            _x.isCustomOptionSet = this.isCustomOptionSet;
            _x.isGlobal = this.isGlobal;
            _x.isManaged = this.isManaged;
            _x.isCustomizable = this.isCustomizable;
            _x.name = this.name;
            _x.externalTypeName = this.externalTypeName;
            _x.optionSetType = this.optionSetType;
            _x.introducedVersion = this.introducedVersion;
            _x.trueOption = this.trueOption;
            _x.falseOption = this.falseOption;
            return _x;
        }
    }
}

