/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import microsoft.dynamics.crm.complex.Object;
import microsoft.dynamics.crm.complex.SubscriptionEntityMetadata;
import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonPropertyOrder(value={"@odata.type", "Metadata", "SyncToken", "IsFinalPage", "MetadataVersion", "ProfileVersion"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SyncSubscriptionMetadataResponse
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="Metadata")
    protected List<SubscriptionEntityMetadata> metadata;
    @JsonProperty(value="Metadata@nextLink")
    protected String metadataNextLink;
    @JsonProperty(value="SyncToken")
    protected String syncToken;
    @JsonProperty(value="IsFinalPage")
    protected Boolean isFinalPage;
    @JsonProperty(value="MetadataVersion")
    protected String metadataVersion;
    @JsonProperty(value="ProfileVersion")
    protected String profileVersion;

    protected SyncSubscriptionMetadataResponse() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.SyncSubscriptionMetadataResponse";
    }

    @Property(name="Metadata")
    @JsonIgnore
    public CollectionPage<SubscriptionEntityMetadata> getMetadata() {
        return new CollectionPage(this.contextPath, SubscriptionEntityMetadata.class, this.metadata, Optional.ofNullable(this.metadataNextLink), (com.github.davidmoten.odata.client.SchemaInfo)SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Metadata")
    @JsonIgnore
    public CollectionPage<SubscriptionEntityMetadata> getMetadata(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, SubscriptionEntityMetadata.class, this.metadata, Optional.ofNullable(this.metadataNextLink), (com.github.davidmoten.odata.client.SchemaInfo)SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="SyncToken")
    @JsonIgnore
    public Optional<String> getSyncToken() {
        return Optional.ofNullable(this.syncToken);
    }

    public SyncSubscriptionMetadataResponse withSyncToken(String syncToken) {
        Checks.checkIsAscii((String)syncToken);
        SyncSubscriptionMetadataResponse _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.SyncSubscriptionMetadataResponse");
        _x.syncToken = syncToken;
        return _x;
    }

    @Property(name="IsFinalPage")
    @JsonIgnore
    public Optional<Boolean> getIsFinalPage() {
        return Optional.ofNullable(this.isFinalPage);
    }

    public SyncSubscriptionMetadataResponse withIsFinalPage(Boolean isFinalPage) {
        SyncSubscriptionMetadataResponse _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.SyncSubscriptionMetadataResponse");
        _x.isFinalPage = isFinalPage;
        return _x;
    }

    @Property(name="MetadataVersion")
    @JsonIgnore
    public Optional<String> getMetadataVersion() {
        return Optional.ofNullable(this.metadataVersion);
    }

    public SyncSubscriptionMetadataResponse withMetadataVersion(String metadataVersion) {
        Checks.checkIsAscii((String)metadataVersion);
        SyncSubscriptionMetadataResponse _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.SyncSubscriptionMetadataResponse");
        _x.metadataVersion = metadataVersion;
        return _x;
    }

    @Property(name="ProfileVersion")
    @JsonIgnore
    public Optional<String> getProfileVersion() {
        return Optional.ofNullable(this.profileVersion);
    }

    public SyncSubscriptionMetadataResponse withProfileVersion(String profileVersion) {
        Checks.checkIsAscii((String)profileVersion);
        SyncSubscriptionMetadataResponse _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.SyncSubscriptionMetadataResponse");
        _x.profileVersion = profileVersion;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFields();
        }
        this.unmappedFields.put(name, (java.lang.Object)value);
    }

    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields == null ? UnmappedFields.EMPTY : this.unmappedFields;
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private SyncSubscriptionMetadataResponse _copy() {
        SyncSubscriptionMetadataResponse _x = new SyncSubscriptionMetadataResponse();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields;
        _x.odataType = this.odataType;
        _x.metadata = this.metadata;
        _x.syncToken = this.syncToken;
        _x.isFinalPage = this.isFinalPage;
        _x.metadataVersion = this.metadataVersion;
        _x.profileVersion = this.profileVersion;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SyncSubscriptionMetadataResponse[");
        b.append("Metadata=");
        b.append(this.metadata);
        b.append(", ");
        b.append("SyncToken=");
        b.append(this.syncToken);
        b.append(", ");
        b.append("IsFinalPage=");
        b.append(this.isFinalPage);
        b.append(", ");
        b.append("MetadataVersion=");
        b.append(this.metadataVersion);
        b.append(", ");
        b.append("ProfileVersion=");
        b.append(this.profileVersion);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private List<SubscriptionEntityMetadata> metadata;
        private String metadataNextLink;
        private String syncToken;
        private Boolean isFinalPage;
        private String metadataVersion;
        private String profileVersion;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder metadata(List<SubscriptionEntityMetadata> metadata) {
            this.metadata = metadata;
            this.changedFields = this.changedFields.add("Metadata");
            return this;
        }

        public Builder metadata(SubscriptionEntityMetadata ... metadata) {
            return this.metadata(Arrays.asList(metadata));
        }

        public Builder metadataNextLink(String metadataNextLink) {
            this.metadataNextLink = metadataNextLink;
            this.changedFields = this.changedFields.add("Metadata");
            return this;
        }

        public Builder syncToken(String syncToken) {
            this.syncToken = syncToken;
            this.changedFields = this.changedFields.add("SyncToken");
            return this;
        }

        public Builder isFinalPage(Boolean isFinalPage) {
            this.isFinalPage = isFinalPage;
            this.changedFields = this.changedFields.add("IsFinalPage");
            return this;
        }

        public Builder metadataVersion(String metadataVersion) {
            this.metadataVersion = metadataVersion;
            this.changedFields = this.changedFields.add("MetadataVersion");
            return this;
        }

        public Builder profileVersion(String profileVersion) {
            this.profileVersion = profileVersion;
            this.changedFields = this.changedFields.add("ProfileVersion");
            return this;
        }

        public SyncSubscriptionMetadataResponse build() {
            SyncSubscriptionMetadataResponse _x = new SyncSubscriptionMetadataResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "Microsoft.Dynamics.CRM.SyncSubscriptionMetadataResponse";
            _x.metadata = this.metadata;
            _x.metadataNextLink = this.metadataNextLink;
            _x.syncToken = this.syncToken;
            _x.isFinalPage = this.isFinalPage;
            _x.metadataVersion = this.metadataVersion;
            _x.profileVersion = this.profileVersion;
            return _x;
        }
    }
}

