/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import microsoft.dynamics.crm.complex.Label;
import microsoft.dynamics.crm.complex.Object;
import microsoft.dynamics.crm.complex.OptionMetadata;

@JsonPropertyOrder(value={"@odata.type", "DefaultStatus", "InvariantName"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class StateOptionMetadata
extends OptionMetadata
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;
    @JsonProperty(value="DefaultStatus")
    protected Integer defaultStatus;
    @JsonProperty(value="InvariantName")
    protected String invariantName;

    protected StateOptionMetadata() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.StateOptionMetadata";
    }

    @Property(name="DefaultStatus")
    @JsonIgnore
    public Optional<Integer> getDefaultStatus() {
        return Optional.ofNullable(this.defaultStatus);
    }

    public StateOptionMetadata withDefaultStatus(Integer defaultStatus) {
        StateOptionMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.StateOptionMetadata");
        _x.defaultStatus = defaultStatus;
        return _x;
    }

    @Property(name="InvariantName")
    @JsonIgnore
    public Optional<String> getInvariantName() {
        return Optional.ofNullable(this.invariantName);
    }

    public StateOptionMetadata withInvariantName(String invariantName) {
        Checks.checkIsAscii((String)invariantName);
        StateOptionMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.StateOptionMetadata");
        _x.invariantName = invariantName;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFields();
        }
        this.unmappedFields.put(name, (java.lang.Object)value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields == null ? UnmappedFields.EMPTY : this.unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builderStateOptionMetadata() {
        return new Builder();
    }

    private StateOptionMetadata _copy() {
        StateOptionMetadata _x = new StateOptionMetadata();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields;
        _x.odataType = this.odataType;
        _x.value = this.value;
        _x.label = this.label;
        _x.description = this.description;
        _x.color = this.color;
        _x.isManaged = this.isManaged;
        _x.externalValue = this.externalValue;
        _x.parentValues = this.parentValues;
        _x.metadataId = this.metadataId;
        _x.hasChanged = this.hasChanged;
        _x.defaultStatus = this.defaultStatus;
        _x.invariantName = this.invariantName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("StateOptionMetadata[");
        b.append("Value=");
        b.append(this.value);
        b.append(", ");
        b.append("Label=");
        b.append(this.label);
        b.append(", ");
        b.append("Description=");
        b.append(this.description);
        b.append(", ");
        b.append("Color=");
        b.append(this.color);
        b.append(", ");
        b.append("IsManaged=");
        b.append(this.isManaged);
        b.append(", ");
        b.append("ExternalValue=");
        b.append(this.externalValue);
        b.append(", ");
        b.append("ParentValues=");
        b.append(this.parentValues);
        b.append(", ");
        b.append("MetadataId=");
        b.append(this.metadataId);
        b.append(", ");
        b.append("HasChanged=");
        b.append(this.hasChanged);
        b.append(", ");
        b.append("DefaultStatus=");
        b.append(this.defaultStatus);
        b.append(", ");
        b.append("InvariantName=");
        b.append(this.invariantName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private Integer value;
        private Label label;
        private Label description;
        private String color;
        private Boolean isManaged;
        private String externalValue;
        private List<Integer> parentValues;
        private String parentValuesNextLink;
        private String metadataId;
        private Boolean hasChanged;
        private Integer defaultStatus;
        private String invariantName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder value(Integer value) {
            this.value = value;
            this.changedFields = this.changedFields.add("Value");
            return this;
        }

        public Builder label(Label label) {
            this.label = label;
            this.changedFields = this.changedFields.add("Label");
            return this;
        }

        public Builder description(Label description) {
            this.description = description;
            this.changedFields = this.changedFields.add("Description");
            return this;
        }

        public Builder color(String color) {
            this.color = color;
            this.changedFields = this.changedFields.add("Color");
            return this;
        }

        public Builder isManaged(Boolean isManaged) {
            this.isManaged = isManaged;
            this.changedFields = this.changedFields.add("IsManaged");
            return this;
        }

        public Builder externalValue(String externalValue) {
            this.externalValue = externalValue;
            this.changedFields = this.changedFields.add("ExternalValue");
            return this;
        }

        public Builder parentValues(List<Integer> parentValues) {
            this.parentValues = parentValues;
            this.changedFields = this.changedFields.add("ParentValues");
            return this;
        }

        public Builder parentValues(Integer ... parentValues) {
            return this.parentValues(Arrays.asList(parentValues));
        }

        public Builder parentValuesNextLink(String parentValuesNextLink) {
            this.parentValuesNextLink = parentValuesNextLink;
            this.changedFields = this.changedFields.add("ParentValues");
            return this;
        }

        public Builder metadataId(String metadataId) {
            this.metadataId = metadataId;
            this.changedFields = this.changedFields.add("MetadataId");
            return this;
        }

        public Builder hasChanged(Boolean hasChanged) {
            this.hasChanged = hasChanged;
            this.changedFields = this.changedFields.add("HasChanged");
            return this;
        }

        public Builder defaultStatus(Integer defaultStatus) {
            this.defaultStatus = defaultStatus;
            this.changedFields = this.changedFields.add("DefaultStatus");
            return this;
        }

        public Builder invariantName(String invariantName) {
            this.invariantName = invariantName;
            this.changedFields = this.changedFields.add("InvariantName");
            return this;
        }

        public StateOptionMetadata build() {
            StateOptionMetadata _x = new StateOptionMetadata();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "Microsoft.Dynamics.CRM.StateOptionMetadata";
            _x.value = this.value;
            _x.label = this.label;
            _x.description = this.description;
            _x.color = this.color;
            _x.isManaged = this.isManaged;
            _x.externalValue = this.externalValue;
            _x.parentValues = this.parentValues;
            _x.parentValuesNextLink = this.parentValuesNextLink;
            _x.metadataId = this.metadataId;
            _x.hasChanged = this.hasChanged;
            _x.defaultStatus = this.defaultStatus;
            _x.invariantName = this.invariantName;
            return _x;
        }
    }
}

