/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import java.util.Optional;
import microsoft.dynamics.crm.complex.Object;
import microsoft.dynamics.crm.enums.SolutionValidationResultType;

@JsonPropertyOrder(value={"@odata.type", "SolutionValidationResultType", "Message", "ErrorCode", "AdditionalInfo"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SolutionValidationResult
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="SolutionValidationResultType")
    protected SolutionValidationResultType solutionValidationResultType;
    @JsonProperty(value="Message")
    protected String message;
    @JsonProperty(value="ErrorCode")
    protected Integer errorCode;
    @JsonProperty(value="AdditionalInfo")
    protected String additionalInfo;

    protected SolutionValidationResult() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.SolutionValidationResult";
    }

    @Property(name="SolutionValidationResultType")
    @JsonIgnore
    public Optional<SolutionValidationResultType> getSolutionValidationResultType() {
        return Optional.ofNullable(this.solutionValidationResultType);
    }

    public SolutionValidationResult withSolutionValidationResultType(SolutionValidationResultType solutionValidationResultType) {
        SolutionValidationResult _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.SolutionValidationResult");
        _x.solutionValidationResultType = solutionValidationResultType;
        return _x;
    }

    @Property(name="Message")
    @JsonIgnore
    public Optional<String> getMessage() {
        return Optional.ofNullable(this.message);
    }

    public SolutionValidationResult withMessage(String message) {
        Checks.checkIsAscii((String)message);
        SolutionValidationResult _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.SolutionValidationResult");
        _x.message = message;
        return _x;
    }

    @Property(name="ErrorCode")
    @JsonIgnore
    public Optional<Integer> getErrorCode() {
        return Optional.ofNullable(this.errorCode);
    }

    public SolutionValidationResult withErrorCode(Integer errorCode) {
        SolutionValidationResult _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.SolutionValidationResult");
        _x.errorCode = errorCode;
        return _x;
    }

    @Property(name="AdditionalInfo")
    @JsonIgnore
    public Optional<String> getAdditionalInfo() {
        return Optional.ofNullable(this.additionalInfo);
    }

    public SolutionValidationResult withAdditionalInfo(String additionalInfo) {
        Checks.checkIsAscii((String)additionalInfo);
        SolutionValidationResult _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.SolutionValidationResult");
        _x.additionalInfo = additionalInfo;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFields();
        }
        this.unmappedFields.put(name, (java.lang.Object)value);
    }

    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields == null ? UnmappedFields.EMPTY : this.unmappedFields;
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private SolutionValidationResult _copy() {
        SolutionValidationResult _x = new SolutionValidationResult();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields;
        _x.odataType = this.odataType;
        _x.solutionValidationResultType = this.solutionValidationResultType;
        _x.message = this.message;
        _x.errorCode = this.errorCode;
        _x.additionalInfo = this.additionalInfo;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SolutionValidationResult[");
        b.append("SolutionValidationResultType=");
        b.append((java.lang.Object)this.solutionValidationResultType);
        b.append(", ");
        b.append("Message=");
        b.append(this.message);
        b.append(", ");
        b.append("ErrorCode=");
        b.append(this.errorCode);
        b.append(", ");
        b.append("AdditionalInfo=");
        b.append(this.additionalInfo);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private SolutionValidationResultType solutionValidationResultType;
        private String message;
        private Integer errorCode;
        private String additionalInfo;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder solutionValidationResultType(SolutionValidationResultType solutionValidationResultType) {
            this.solutionValidationResultType = solutionValidationResultType;
            this.changedFields = this.changedFields.add("SolutionValidationResultType");
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            this.changedFields = this.changedFields.add("Message");
            return this;
        }

        public Builder errorCode(Integer errorCode) {
            this.errorCode = errorCode;
            this.changedFields = this.changedFields.add("ErrorCode");
            return this;
        }

        public Builder additionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
            this.changedFields = this.changedFields.add("AdditionalInfo");
            return this;
        }

        public SolutionValidationResult build() {
            SolutionValidationResult _x = new SolutionValidationResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "Microsoft.Dynamics.CRM.SolutionValidationResult";
            _x.solutionValidationResultType = this.solutionValidationResultType;
            _x.message = this.message;
            _x.errorCode = this.errorCode;
            _x.additionalInfo = this.additionalInfo;
            return _x;
        }
    }
}

