/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import java.util.Optional;
import microsoft.dynamics.crm.complex.Object;

@JsonPropertyOrder(value={"@odata.type", "Id", "VersionNumber", "SolutionUniqueName", "FriendlyName", "PublisherId", "PublisherIdName", "PublisherUniqueName"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Solution
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="Id")
    protected String id;
    @JsonProperty(value="VersionNumber")
    protected String versionNumber;
    @JsonProperty(value="SolutionUniqueName")
    protected String solutionUniqueName;
    @JsonProperty(value="FriendlyName")
    protected String friendlyName;
    @JsonProperty(value="PublisherId")
    protected String publisherId;
    @JsonProperty(value="PublisherIdName")
    protected String publisherIdName;
    @JsonProperty(value="PublisherUniqueName")
    protected String publisherUniqueName;

    protected Solution() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.Solution";
    }

    @Property(name="Id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(this.id);
    }

    public Solution withId(String id) {
        Solution _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.Solution");
        _x.id = id;
        return _x;
    }

    @Property(name="VersionNumber")
    @JsonIgnore
    public Optional<String> getVersionNumber() {
        return Optional.ofNullable(this.versionNumber);
    }

    public Solution withVersionNumber(String versionNumber) {
        Checks.checkIsAscii((String)versionNumber);
        Solution _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.Solution");
        _x.versionNumber = versionNumber;
        return _x;
    }

    @Property(name="SolutionUniqueName")
    @JsonIgnore
    public Optional<String> getSolutionUniqueName() {
        return Optional.ofNullable(this.solutionUniqueName);
    }

    public Solution withSolutionUniqueName(String solutionUniqueName) {
        Checks.checkIsAscii((String)solutionUniqueName);
        Solution _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.Solution");
        _x.solutionUniqueName = solutionUniqueName;
        return _x;
    }

    @Property(name="FriendlyName")
    @JsonIgnore
    public Optional<String> getFriendlyName() {
        return Optional.ofNullable(this.friendlyName);
    }

    public Solution withFriendlyName(String friendlyName) {
        Checks.checkIsAscii((String)friendlyName);
        Solution _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.Solution");
        _x.friendlyName = friendlyName;
        return _x;
    }

    @Property(name="PublisherId")
    @JsonIgnore
    public Optional<String> getPublisherId() {
        return Optional.ofNullable(this.publisherId);
    }

    public Solution withPublisherId(String publisherId) {
        Solution _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.Solution");
        _x.publisherId = publisherId;
        return _x;
    }

    @Property(name="PublisherIdName")
    @JsonIgnore
    public Optional<String> getPublisherIdName() {
        return Optional.ofNullable(this.publisherIdName);
    }

    public Solution withPublisherIdName(String publisherIdName) {
        Checks.checkIsAscii((String)publisherIdName);
        Solution _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.Solution");
        _x.publisherIdName = publisherIdName;
        return _x;
    }

    @Property(name="PublisherUniqueName")
    @JsonIgnore
    public Optional<String> getPublisherUniqueName() {
        return Optional.ofNullable(this.publisherUniqueName);
    }

    public Solution withPublisherUniqueName(String publisherUniqueName) {
        Checks.checkIsAscii((String)publisherUniqueName);
        Solution _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.Solution");
        _x.publisherUniqueName = publisherUniqueName;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFields();
        }
        this.unmappedFields.put(name, (java.lang.Object)value);
    }

    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields == null ? UnmappedFields.EMPTY : this.unmappedFields;
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private Solution _copy() {
        Solution _x = new Solution();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields;
        _x.odataType = this.odataType;
        _x.id = this.id;
        _x.versionNumber = this.versionNumber;
        _x.solutionUniqueName = this.solutionUniqueName;
        _x.friendlyName = this.friendlyName;
        _x.publisherId = this.publisherId;
        _x.publisherIdName = this.publisherIdName;
        _x.publisherUniqueName = this.publisherUniqueName;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Solution[");
        b.append("Id=");
        b.append(this.id);
        b.append(", ");
        b.append("VersionNumber=");
        b.append(this.versionNumber);
        b.append(", ");
        b.append("SolutionUniqueName=");
        b.append(this.solutionUniqueName);
        b.append(", ");
        b.append("FriendlyName=");
        b.append(this.friendlyName);
        b.append(", ");
        b.append("PublisherId=");
        b.append(this.publisherId);
        b.append(", ");
        b.append("PublisherIdName=");
        b.append(this.publisherIdName);
        b.append(", ");
        b.append("PublisherUniqueName=");
        b.append(this.publisherUniqueName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private String id;
        private String versionNumber;
        private String solutionUniqueName;
        private String friendlyName;
        private String publisherId;
        private String publisherIdName;
        private String publisherUniqueName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = this.changedFields.add("Id");
            return this;
        }

        public Builder versionNumber(String versionNumber) {
            this.versionNumber = versionNumber;
            this.changedFields = this.changedFields.add("VersionNumber");
            return this;
        }

        public Builder solutionUniqueName(String solutionUniqueName) {
            this.solutionUniqueName = solutionUniqueName;
            this.changedFields = this.changedFields.add("SolutionUniqueName");
            return this;
        }

        public Builder friendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
            this.changedFields = this.changedFields.add("FriendlyName");
            return this;
        }

        public Builder publisherId(String publisherId) {
            this.publisherId = publisherId;
            this.changedFields = this.changedFields.add("PublisherId");
            return this;
        }

        public Builder publisherIdName(String publisherIdName) {
            this.publisherIdName = publisherIdName;
            this.changedFields = this.changedFields.add("PublisherIdName");
            return this;
        }

        public Builder publisherUniqueName(String publisherUniqueName) {
            this.publisherUniqueName = publisherUniqueName;
            this.changedFields = this.changedFields.add("PublisherUniqueName");
            return this;
        }

        public Solution build() {
            Solution _x = new Solution();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "Microsoft.Dynamics.CRM.Solution";
            _x.id = this.id;
            _x.versionNumber = this.versionNumber;
            _x.solutionUniqueName = this.solutionUniqueName;
            _x.friendlyName = this.friendlyName;
            _x.publisherId = this.publisherId;
            _x.publisherIdName = this.publisherIdName;
            _x.publisherUniqueName = this.publisherUniqueName;
            return _x;
        }
    }
}

