/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import microsoft.dynamics.crm.complex.ComplexEntityMetadata;
import microsoft.dynamics.crm.complex.Object;
import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonPropertyOrder(value={"@odata.type", "EntityMetadata", "Timestamp"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RetrieveAllEntitiesResponse
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="EntityMetadata")
    protected List<ComplexEntityMetadata> entityMetadata;
    @JsonProperty(value="EntityMetadata@nextLink")
    protected String entityMetadataNextLink;
    @JsonProperty(value="Timestamp")
    protected String timestamp;

    protected RetrieveAllEntitiesResponse() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.RetrieveAllEntitiesResponse";
    }

    @Property(name="EntityMetadata")
    @JsonIgnore
    public CollectionPage<ComplexEntityMetadata> getEntityMetadata() {
        return new CollectionPage(this.contextPath, ComplexEntityMetadata.class, this.entityMetadata, Optional.ofNullable(this.entityMetadataNextLink), (com.github.davidmoten.odata.client.SchemaInfo)SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="EntityMetadata")
    @JsonIgnore
    public CollectionPage<ComplexEntityMetadata> getEntityMetadata(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, ComplexEntityMetadata.class, this.entityMetadata, Optional.ofNullable(this.entityMetadataNextLink), (com.github.davidmoten.odata.client.SchemaInfo)SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="Timestamp")
    @JsonIgnore
    public Optional<String> getTimestamp() {
        return Optional.ofNullable(this.timestamp);
    }

    public RetrieveAllEntitiesResponse withTimestamp(String timestamp) {
        Checks.checkIsAscii((String)timestamp);
        RetrieveAllEntitiesResponse _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.RetrieveAllEntitiesResponse");
        _x.timestamp = timestamp;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFields();
        }
        this.unmappedFields.put(name, (java.lang.Object)value);
    }

    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields == null ? UnmappedFields.EMPTY : this.unmappedFields;
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private RetrieveAllEntitiesResponse _copy() {
        RetrieveAllEntitiesResponse _x = new RetrieveAllEntitiesResponse();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields;
        _x.odataType = this.odataType;
        _x.entityMetadata = this.entityMetadata;
        _x.timestamp = this.timestamp;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RetrieveAllEntitiesResponse[");
        b.append("EntityMetadata=");
        b.append(this.entityMetadata);
        b.append(", ");
        b.append("Timestamp=");
        b.append(this.timestamp);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private List<ComplexEntityMetadata> entityMetadata;
        private String entityMetadataNextLink;
        private String timestamp;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder entityMetadata(List<ComplexEntityMetadata> entityMetadata) {
            this.entityMetadata = entityMetadata;
            this.changedFields = this.changedFields.add("EntityMetadata");
            return this;
        }

        public Builder entityMetadata(ComplexEntityMetadata ... entityMetadata) {
            return this.entityMetadata(Arrays.asList(entityMetadata));
        }

        public Builder entityMetadataNextLink(String entityMetadataNextLink) {
            this.entityMetadataNextLink = entityMetadataNextLink;
            this.changedFields = this.changedFields.add("EntityMetadata");
            return this;
        }

        public Builder timestamp(String timestamp) {
            this.timestamp = timestamp;
            this.changedFields = this.changedFields.add("Timestamp");
            return this;
        }

        public RetrieveAllEntitiesResponse build() {
            RetrieveAllEntitiesResponse _x = new RetrieveAllEntitiesResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "Microsoft.Dynamics.CRM.RetrieveAllEntitiesResponse";
            _x.entityMetadata = this.entityMetadata;
            _x.entityMetadataNextLink = this.entityMetadataNextLink;
            _x.timestamp = this.timestamp;
            return _x;
        }
    }
}

