/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import microsoft.dynamics.crm.complex.BusinessNotification;
import microsoft.dynamics.crm.complex.Object;
import microsoft.dynamics.crm.complex.ValidationResult;
import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonPropertyOrder(value={"@odata.type", "ValidationResult", "Notifications"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RescheduleResponse
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="ValidationResult")
    protected ValidationResult validationResult;
    @JsonProperty(value="Notifications")
    protected List<BusinessNotification> notifications;
    @JsonProperty(value="Notifications@nextLink")
    protected String notificationsNextLink;

    protected RescheduleResponse() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.RescheduleResponse";
    }

    @Property(name="ValidationResult")
    @JsonIgnore
    public Optional<ValidationResult> getValidationResult() {
        return Optional.ofNullable(this.validationResult);
    }

    public RescheduleResponse withValidationResult(ValidationResult validationResult) {
        RescheduleResponse _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.RescheduleResponse");
        _x.validationResult = validationResult;
        return _x;
    }

    @Property(name="Notifications")
    @JsonIgnore
    public CollectionPage<BusinessNotification> getNotifications() {
        return new CollectionPage(this.contextPath, BusinessNotification.class, this.notifications, Optional.ofNullable(this.notificationsNextLink), (com.github.davidmoten.odata.client.SchemaInfo)SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Notifications")
    @JsonIgnore
    public CollectionPage<BusinessNotification> getNotifications(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, BusinessNotification.class, this.notifications, Optional.ofNullable(this.notificationsNextLink), (com.github.davidmoten.odata.client.SchemaInfo)SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFields();
        }
        this.unmappedFields.put(name, (java.lang.Object)value);
    }

    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields == null ? UnmappedFields.EMPTY : this.unmappedFields;
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private RescheduleResponse _copy() {
        RescheduleResponse _x = new RescheduleResponse();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields;
        _x.odataType = this.odataType;
        _x.validationResult = this.validationResult;
        _x.notifications = this.notifications;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RescheduleResponse[");
        b.append("ValidationResult=");
        b.append(this.validationResult);
        b.append(", ");
        b.append("Notifications=");
        b.append(this.notifications);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private ValidationResult validationResult;
        private List<BusinessNotification> notifications;
        private String notificationsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder validationResult(ValidationResult validationResult) {
            this.validationResult = validationResult;
            this.changedFields = this.changedFields.add("ValidationResult");
            return this;
        }

        public Builder notifications(List<BusinessNotification> notifications) {
            this.notifications = notifications;
            this.changedFields = this.changedFields.add("Notifications");
            return this;
        }

        public Builder notifications(BusinessNotification ... notifications) {
            return this.notifications(Arrays.asList(notifications));
        }

        public Builder notificationsNextLink(String notificationsNextLink) {
            this.notificationsNextLink = notificationsNextLink;
            this.changedFields = this.changedFields.add("Notifications");
            return this;
        }

        public RescheduleResponse build() {
            RescheduleResponse _x = new RescheduleResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "Microsoft.Dynamics.CRM.RescheduleResponse";
            _x.validationResult = this.validationResult;
            _x.notifications = this.notifications;
            _x.notificationsNextLink = this.notificationsNextLink;
            return _x;
        }
    }
}

