/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import microsoft.dynamics.crm.complex.ColumnSet;
import microsoft.dynamics.crm.complex.FilterExpression;
import microsoft.dynamics.crm.complex.LinkEntity;
import microsoft.dynamics.crm.complex.Object;
import microsoft.dynamics.crm.complex.OrderExpression;
import microsoft.dynamics.crm.complex.PagingInfo;
import microsoft.dynamics.crm.complex.QueryBase;
import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonPropertyOrder(value={"@odata.type", "Distinct", "NoLock", "SubQueryExpression", "PageInfo", "QueryHints", "LinkEntities", "Criteria", "Orders", "EntityName", "ColumnSet", "TopCount"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class QueryExpression
extends QueryBase
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;
    @JsonProperty(value="Distinct")
    protected Boolean distinct;
    @JsonProperty(value="NoLock")
    protected Boolean noLock;
    @JsonProperty(value="SubQueryExpression")
    protected QueryExpression subQueryExpression;
    @JsonProperty(value="PageInfo")
    protected PagingInfo pageInfo;
    @JsonProperty(value="QueryHints")
    protected String queryHints;
    @JsonProperty(value="LinkEntities")
    protected List<LinkEntity> linkEntities;
    @JsonProperty(value="LinkEntities@nextLink")
    protected String linkEntitiesNextLink;
    @JsonProperty(value="Criteria")
    protected FilterExpression criteria;
    @JsonProperty(value="Orders")
    protected List<OrderExpression> orders;
    @JsonProperty(value="Orders@nextLink")
    protected String ordersNextLink;
    @JsonProperty(value="EntityName")
    protected String entityName;
    @JsonProperty(value="ColumnSet")
    protected ColumnSet columnSet;
    @JsonProperty(value="TopCount")
    protected Integer topCount;

    protected QueryExpression() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.QueryExpression";
    }

    @Property(name="Distinct")
    @JsonIgnore
    public Optional<Boolean> getDistinct() {
        return Optional.ofNullable(this.distinct);
    }

    public QueryExpression withDistinct(Boolean distinct) {
        QueryExpression _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.QueryExpression");
        _x.distinct = distinct;
        return _x;
    }

    @Property(name="NoLock")
    @JsonIgnore
    public Optional<Boolean> getNoLock() {
        return Optional.ofNullable(this.noLock);
    }

    public QueryExpression withNoLock(Boolean noLock) {
        QueryExpression _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.QueryExpression");
        _x.noLock = noLock;
        return _x;
    }

    @Property(name="SubQueryExpression")
    @JsonIgnore
    public Optional<QueryExpression> getSubQueryExpression() {
        return Optional.ofNullable(this.subQueryExpression);
    }

    public QueryExpression withSubQueryExpression(QueryExpression subQueryExpression) {
        QueryExpression _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.QueryExpression");
        _x.subQueryExpression = subQueryExpression;
        return _x;
    }

    @Property(name="PageInfo")
    @JsonIgnore
    public Optional<PagingInfo> getPageInfo() {
        return Optional.ofNullable(this.pageInfo);
    }

    public QueryExpression withPageInfo(PagingInfo pageInfo) {
        QueryExpression _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.QueryExpression");
        _x.pageInfo = pageInfo;
        return _x;
    }

    @Property(name="QueryHints")
    @JsonIgnore
    public Optional<String> getQueryHints() {
        return Optional.ofNullable(this.queryHints);
    }

    public QueryExpression withQueryHints(String queryHints) {
        Checks.checkIsAscii((String)queryHints);
        QueryExpression _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.QueryExpression");
        _x.queryHints = queryHints;
        return _x;
    }

    @Property(name="LinkEntities")
    @JsonIgnore
    public CollectionPage<LinkEntity> getLinkEntities() {
        return new CollectionPage(this.contextPath, LinkEntity.class, this.linkEntities, Optional.ofNullable(this.linkEntitiesNextLink), (com.github.davidmoten.odata.client.SchemaInfo)SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="LinkEntities")
    @JsonIgnore
    public CollectionPage<LinkEntity> getLinkEntities(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, LinkEntity.class, this.linkEntities, Optional.ofNullable(this.linkEntitiesNextLink), (com.github.davidmoten.odata.client.SchemaInfo)SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="Criteria")
    @JsonIgnore
    public Optional<FilterExpression> getCriteria() {
        return Optional.ofNullable(this.criteria);
    }

    public QueryExpression withCriteria(FilterExpression criteria) {
        QueryExpression _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.QueryExpression");
        _x.criteria = criteria;
        return _x;
    }

    @Property(name="Orders")
    @JsonIgnore
    public CollectionPage<OrderExpression> getOrders() {
        return new CollectionPage(this.contextPath, OrderExpression.class, this.orders, Optional.ofNullable(this.ordersNextLink), (com.github.davidmoten.odata.client.SchemaInfo)SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Orders")
    @JsonIgnore
    public CollectionPage<OrderExpression> getOrders(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, OrderExpression.class, this.orders, Optional.ofNullable(this.ordersNextLink), (com.github.davidmoten.odata.client.SchemaInfo)SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="EntityName")
    @JsonIgnore
    public Optional<String> getEntityName() {
        return Optional.ofNullable(this.entityName);
    }

    public QueryExpression withEntityName(String entityName) {
        Checks.checkIsAscii((String)entityName);
        QueryExpression _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.QueryExpression");
        _x.entityName = entityName;
        return _x;
    }

    @Property(name="ColumnSet")
    @JsonIgnore
    public Optional<ColumnSet> getColumnSet() {
        return Optional.ofNullable(this.columnSet);
    }

    public QueryExpression withColumnSet(ColumnSet columnSet) {
        QueryExpression _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.QueryExpression");
        _x.columnSet = columnSet;
        return _x;
    }

    @Property(name="TopCount")
    @JsonIgnore
    public Optional<Integer> getTopCount() {
        return Optional.ofNullable(this.topCount);
    }

    public QueryExpression withTopCount(Integer topCount) {
        QueryExpression _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.QueryExpression");
        _x.topCount = topCount;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFields();
        }
        this.unmappedFields.put(name, (java.lang.Object)value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields == null ? UnmappedFields.EMPTY : this.unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builderQueryExpression() {
        return new Builder();
    }

    private QueryExpression _copy() {
        QueryExpression _x = new QueryExpression();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields;
        _x.odataType = this.odataType;
        _x.distinct = this.distinct;
        _x.noLock = this.noLock;
        _x.subQueryExpression = this.subQueryExpression;
        _x.pageInfo = this.pageInfo;
        _x.queryHints = this.queryHints;
        _x.linkEntities = this.linkEntities;
        _x.criteria = this.criteria;
        _x.orders = this.orders;
        _x.entityName = this.entityName;
        _x.columnSet = this.columnSet;
        _x.topCount = this.topCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("QueryExpression[");
        b.append("Distinct=");
        b.append(this.distinct);
        b.append(", ");
        b.append("NoLock=");
        b.append(this.noLock);
        b.append(", ");
        b.append("SubQueryExpression=");
        b.append(this.subQueryExpression);
        b.append(", ");
        b.append("PageInfo=");
        b.append(this.pageInfo);
        b.append(", ");
        b.append("QueryHints=");
        b.append(this.queryHints);
        b.append(", ");
        b.append("LinkEntities=");
        b.append(this.linkEntities);
        b.append(", ");
        b.append("Criteria=");
        b.append(this.criteria);
        b.append(", ");
        b.append("Orders=");
        b.append(this.orders);
        b.append(", ");
        b.append("EntityName=");
        b.append(this.entityName);
        b.append(", ");
        b.append("ColumnSet=");
        b.append(this.columnSet);
        b.append(", ");
        b.append("TopCount=");
        b.append(this.topCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private Boolean distinct;
        private Boolean noLock;
        private QueryExpression subQueryExpression;
        private PagingInfo pageInfo;
        private String queryHints;
        private List<LinkEntity> linkEntities;
        private String linkEntitiesNextLink;
        private FilterExpression criteria;
        private List<OrderExpression> orders;
        private String ordersNextLink;
        private String entityName;
        private ColumnSet columnSet;
        private Integer topCount;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder distinct(Boolean distinct) {
            this.distinct = distinct;
            this.changedFields = this.changedFields.add("Distinct");
            return this;
        }

        public Builder noLock(Boolean noLock) {
            this.noLock = noLock;
            this.changedFields = this.changedFields.add("NoLock");
            return this;
        }

        public Builder subQueryExpression(QueryExpression subQueryExpression) {
            this.subQueryExpression = subQueryExpression;
            this.changedFields = this.changedFields.add("SubQueryExpression");
            return this;
        }

        public Builder pageInfo(PagingInfo pageInfo) {
            this.pageInfo = pageInfo;
            this.changedFields = this.changedFields.add("PageInfo");
            return this;
        }

        public Builder queryHints(String queryHints) {
            this.queryHints = queryHints;
            this.changedFields = this.changedFields.add("QueryHints");
            return this;
        }

        public Builder linkEntities(List<LinkEntity> linkEntities) {
            this.linkEntities = linkEntities;
            this.changedFields = this.changedFields.add("LinkEntities");
            return this;
        }

        public Builder linkEntities(LinkEntity ... linkEntities) {
            return this.linkEntities(Arrays.asList(linkEntities));
        }

        public Builder linkEntitiesNextLink(String linkEntitiesNextLink) {
            this.linkEntitiesNextLink = linkEntitiesNextLink;
            this.changedFields = this.changedFields.add("LinkEntities");
            return this;
        }

        public Builder criteria(FilterExpression criteria) {
            this.criteria = criteria;
            this.changedFields = this.changedFields.add("Criteria");
            return this;
        }

        public Builder orders(List<OrderExpression> orders) {
            this.orders = orders;
            this.changedFields = this.changedFields.add("Orders");
            return this;
        }

        public Builder orders(OrderExpression ... orders) {
            return this.orders(Arrays.asList(orders));
        }

        public Builder ordersNextLink(String ordersNextLink) {
            this.ordersNextLink = ordersNextLink;
            this.changedFields = this.changedFields.add("Orders");
            return this;
        }

        public Builder entityName(String entityName) {
            this.entityName = entityName;
            this.changedFields = this.changedFields.add("EntityName");
            return this;
        }

        public Builder columnSet(ColumnSet columnSet) {
            this.columnSet = columnSet;
            this.changedFields = this.changedFields.add("ColumnSet");
            return this;
        }

        public Builder topCount(Integer topCount) {
            this.topCount = topCount;
            this.changedFields = this.changedFields.add("TopCount");
            return this;
        }

        public QueryExpression build() {
            QueryExpression _x = new QueryExpression();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "Microsoft.Dynamics.CRM.QueryExpression";
            _x.distinct = this.distinct;
            _x.noLock = this.noLock;
            _x.subQueryExpression = this.subQueryExpression;
            _x.pageInfo = this.pageInfo;
            _x.queryHints = this.queryHints;
            _x.linkEntities = this.linkEntities;
            _x.linkEntitiesNextLink = this.linkEntitiesNextLink;
            _x.criteria = this.criteria;
            _x.orders = this.orders;
            _x.ordersNextLink = this.ordersNextLink;
            _x.entityName = this.entityName;
            _x.columnSet = this.columnSet;
            _x.topCount = this.topCount;
            return _x;
        }
    }
}

