/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import java.util.Optional;
import microsoft.dynamics.crm.complex.Object;
import microsoft.dynamics.crm.enums.OrderType;

@JsonPropertyOrder(value={"@odata.type", "AttributeName", "OrderType", "Alias"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OrderExpression
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="AttributeName")
    protected String attributeName;
    @JsonProperty(value="OrderType")
    protected OrderType orderType;
    @JsonProperty(value="Alias")
    protected String alias;

    protected OrderExpression() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.OrderExpression";
    }

    @Property(name="AttributeName")
    @JsonIgnore
    public Optional<String> getAttributeName() {
        return Optional.ofNullable(this.attributeName);
    }

    public OrderExpression withAttributeName(String attributeName) {
        Checks.checkIsAscii((String)attributeName);
        OrderExpression _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.OrderExpression");
        _x.attributeName = attributeName;
        return _x;
    }

    @Property(name="OrderType")
    @JsonIgnore
    public Optional<OrderType> getOrderType() {
        return Optional.ofNullable(this.orderType);
    }

    public OrderExpression withOrderType(OrderType orderType) {
        OrderExpression _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.OrderExpression");
        _x.orderType = orderType;
        return _x;
    }

    @Property(name="Alias")
    @JsonIgnore
    public Optional<String> getAlias() {
        return Optional.ofNullable(this.alias);
    }

    public OrderExpression withAlias(String alias) {
        Checks.checkIsAscii((String)alias);
        OrderExpression _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.OrderExpression");
        _x.alias = alias;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFields();
        }
        this.unmappedFields.put(name, (java.lang.Object)value);
    }

    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields == null ? UnmappedFields.EMPTY : this.unmappedFields;
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private OrderExpression _copy() {
        OrderExpression _x = new OrderExpression();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields;
        _x.odataType = this.odataType;
        _x.attributeName = this.attributeName;
        _x.orderType = this.orderType;
        _x.alias = this.alias;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OrderExpression[");
        b.append("AttributeName=");
        b.append(this.attributeName);
        b.append(", ");
        b.append("OrderType=");
        b.append((java.lang.Object)this.orderType);
        b.append(", ");
        b.append("Alias=");
        b.append(this.alias);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private String attributeName;
        private OrderType orderType;
        private String alias;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            this.changedFields = this.changedFields.add("AttributeName");
            return this;
        }

        public Builder orderType(OrderType orderType) {
            this.orderType = orderType;
            this.changedFields = this.changedFields.add("OrderType");
            return this;
        }

        public Builder alias(String alias) {
            this.alias = alias;
            this.changedFields = this.changedFields.add("Alias");
            return this;
        }

        public OrderExpression build() {
            OrderExpression _x = new OrderExpression();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "Microsoft.Dynamics.CRM.OrderExpression";
            _x.attributeName = this.attributeName;
            _x.orderType = this.orderType;
            _x.alias = this.alias;
            return _x;
        }
    }
}

