/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import java.util.Optional;
import microsoft.dynamics.crm.complex.Object;
import microsoft.dynamics.crm.enums.MetadataConditionOperator;

@JsonPropertyOrder(value={"@odata.type", "PropertyName", "ConditionOperator", "Value"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MetadataConditionExpression
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="PropertyName")
    protected String propertyName;
    @JsonProperty(value="ConditionOperator")
    protected MetadataConditionOperator conditionOperator;
    @JsonProperty(value="Value")
    protected Object value;

    protected MetadataConditionExpression() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.MetadataConditionExpression";
    }

    @Property(name="PropertyName")
    @JsonIgnore
    public Optional<String> getPropertyName() {
        return Optional.ofNullable(this.propertyName);
    }

    public MetadataConditionExpression withPropertyName(String propertyName) {
        Checks.checkIsAscii((String)propertyName);
        MetadataConditionExpression _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.MetadataConditionExpression");
        _x.propertyName = propertyName;
        return _x;
    }

    @Property(name="ConditionOperator")
    @JsonIgnore
    public Optional<MetadataConditionOperator> getConditionOperator() {
        return Optional.ofNullable(this.conditionOperator);
    }

    public MetadataConditionExpression withConditionOperator(MetadataConditionOperator conditionOperator) {
        MetadataConditionExpression _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.MetadataConditionExpression");
        _x.conditionOperator = conditionOperator;
        return _x;
    }

    @Property(name="Value")
    @JsonIgnore
    public Optional<Object> getValue() {
        return Optional.ofNullable(this.value);
    }

    public MetadataConditionExpression withValue(Object value) {
        MetadataConditionExpression _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.MetadataConditionExpression");
        _x.value = value;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFields();
        }
        this.unmappedFields.put(name, (java.lang.Object)value);
    }

    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields == null ? UnmappedFields.EMPTY : this.unmappedFields;
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private MetadataConditionExpression _copy() {
        MetadataConditionExpression _x = new MetadataConditionExpression();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields;
        _x.odataType = this.odataType;
        _x.propertyName = this.propertyName;
        _x.conditionOperator = this.conditionOperator;
        _x.value = this.value;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MetadataConditionExpression[");
        b.append("PropertyName=");
        b.append(this.propertyName);
        b.append(", ");
        b.append("ConditionOperator=");
        b.append((java.lang.Object)this.conditionOperator);
        b.append(", ");
        b.append("Value=");
        b.append(this.value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private String propertyName;
        private MetadataConditionOperator conditionOperator;
        private Object value;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder propertyName(String propertyName) {
            this.propertyName = propertyName;
            this.changedFields = this.changedFields.add("PropertyName");
            return this;
        }

        public Builder conditionOperator(MetadataConditionOperator conditionOperator) {
            this.conditionOperator = conditionOperator;
            this.changedFields = this.changedFields.add("ConditionOperator");
            return this;
        }

        public Builder value(Object value) {
            this.value = value;
            this.changedFields = this.changedFields.add("Value");
            return this;
        }

        public MetadataConditionExpression build() {
            MetadataConditionExpression _x = new MetadataConditionExpression();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "Microsoft.Dynamics.CRM.MetadataConditionExpression";
            _x.propertyName = this.propertyName;
            _x.conditionOperator = this.conditionOperator;
            _x.value = this.value;
            return _x;
        }
    }
}

