/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import microsoft.dynamics.crm.complex.Object;
import microsoft.dynamics.crm.complex.ViewColumn;
import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonPropertyOrder(value={"@odata.type", "ViewId", "ViewName", "Columns", "FetchXml", "LayoutJson"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class LookupView
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="ViewId")
    protected String viewId;
    @JsonProperty(value="ViewName")
    protected String viewName;
    @JsonProperty(value="Columns")
    protected List<ViewColumn> columns;
    @JsonProperty(value="Columns@nextLink")
    protected String columnsNextLink;
    @JsonProperty(value="FetchXml")
    protected String fetchXml;
    @JsonProperty(value="LayoutJson")
    protected String layoutJson;

    protected LookupView() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.LookupView";
    }

    @Property(name="ViewId")
    @JsonIgnore
    public Optional<String> getViewId() {
        return Optional.ofNullable(this.viewId);
    }

    public LookupView withViewId(String viewId) {
        LookupView _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.LookupView");
        _x.viewId = viewId;
        return _x;
    }

    @Property(name="ViewName")
    @JsonIgnore
    public Optional<String> getViewName() {
        return Optional.ofNullable(this.viewName);
    }

    public LookupView withViewName(String viewName) {
        Checks.checkIsAscii((String)viewName);
        LookupView _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.LookupView");
        _x.viewName = viewName;
        return _x;
    }

    @Property(name="Columns")
    @JsonIgnore
    public CollectionPage<ViewColumn> getColumns() {
        return new CollectionPage(this.contextPath, ViewColumn.class, this.columns, Optional.ofNullable(this.columnsNextLink), (com.github.davidmoten.odata.client.SchemaInfo)SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Columns")
    @JsonIgnore
    public CollectionPage<ViewColumn> getColumns(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, ViewColumn.class, this.columns, Optional.ofNullable(this.columnsNextLink), (com.github.davidmoten.odata.client.SchemaInfo)SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="FetchXml")
    @JsonIgnore
    public Optional<String> getFetchXml() {
        return Optional.ofNullable(this.fetchXml);
    }

    public LookupView withFetchXml(String fetchXml) {
        Checks.checkIsAscii((String)fetchXml);
        LookupView _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.LookupView");
        _x.fetchXml = fetchXml;
        return _x;
    }

    @Property(name="LayoutJson")
    @JsonIgnore
    public Optional<String> getLayoutJson() {
        return Optional.ofNullable(this.layoutJson);
    }

    public LookupView withLayoutJson(String layoutJson) {
        Checks.checkIsAscii((String)layoutJson);
        LookupView _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.LookupView");
        _x.layoutJson = layoutJson;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFields();
        }
        this.unmappedFields.put(name, (java.lang.Object)value);
    }

    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields == null ? UnmappedFields.EMPTY : this.unmappedFields;
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private LookupView _copy() {
        LookupView _x = new LookupView();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields;
        _x.odataType = this.odataType;
        _x.viewId = this.viewId;
        _x.viewName = this.viewName;
        _x.columns = this.columns;
        _x.fetchXml = this.fetchXml;
        _x.layoutJson = this.layoutJson;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LookupView[");
        b.append("ViewId=");
        b.append(this.viewId);
        b.append(", ");
        b.append("ViewName=");
        b.append(this.viewName);
        b.append(", ");
        b.append("Columns=");
        b.append(this.columns);
        b.append(", ");
        b.append("FetchXml=");
        b.append(this.fetchXml);
        b.append(", ");
        b.append("LayoutJson=");
        b.append(this.layoutJson);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private String viewId;
        private String viewName;
        private List<ViewColumn> columns;
        private String columnsNextLink;
        private String fetchXml;
        private String layoutJson;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder viewId(String viewId) {
            this.viewId = viewId;
            this.changedFields = this.changedFields.add("ViewId");
            return this;
        }

        public Builder viewName(String viewName) {
            this.viewName = viewName;
            this.changedFields = this.changedFields.add("ViewName");
            return this;
        }

        public Builder columns(List<ViewColumn> columns) {
            this.columns = columns;
            this.changedFields = this.changedFields.add("Columns");
            return this;
        }

        public Builder columns(ViewColumn ... columns) {
            return this.columns(Arrays.asList(columns));
        }

        public Builder columnsNextLink(String columnsNextLink) {
            this.columnsNextLink = columnsNextLink;
            this.changedFields = this.changedFields.add("Columns");
            return this;
        }

        public Builder fetchXml(String fetchXml) {
            this.fetchXml = fetchXml;
            this.changedFields = this.changedFields.add("FetchXml");
            return this;
        }

        public Builder layoutJson(String layoutJson) {
            this.layoutJson = layoutJson;
            this.changedFields = this.changedFields.add("LayoutJson");
            return this;
        }

        public LookupView build() {
            LookupView _x = new LookupView();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "Microsoft.Dynamics.CRM.LookupView";
            _x.viewId = this.viewId;
            _x.viewName = this.viewName;
            _x.columns = this.columns;
            _x.columnsNextLink = this.columnsNextLink;
            _x.fetchXml = this.fetchXml;
            _x.layoutJson = this.layoutJson;
            return _x;
        }
    }
}

