/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import java.util.Optional;
import microsoft.dynamics.crm.complex.Object;

@JsonPropertyOrder(value={"@odata.type", "Label", "LanguageCode"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class LocalizedLabelInfo
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="Label")
    protected String label;
    @JsonProperty(value="LanguageCode")
    protected Integer languageCode;

    protected LocalizedLabelInfo() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.LocalizedLabelInfo";
    }

    @Property(name="Label")
    @JsonIgnore
    public Optional<String> getLabel() {
        return Optional.ofNullable(this.label);
    }

    public LocalizedLabelInfo withLabel(String label) {
        Checks.checkIsAscii((String)label);
        LocalizedLabelInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.LocalizedLabelInfo");
        _x.label = label;
        return _x;
    }

    @Property(name="LanguageCode")
    @JsonIgnore
    public Optional<Integer> getLanguageCode() {
        return Optional.ofNullable(this.languageCode);
    }

    public LocalizedLabelInfo withLanguageCode(Integer languageCode) {
        LocalizedLabelInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.LocalizedLabelInfo");
        _x.languageCode = languageCode;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFields();
        }
        this.unmappedFields.put(name, (java.lang.Object)value);
    }

    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields == null ? UnmappedFields.EMPTY : this.unmappedFields;
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private LocalizedLabelInfo _copy() {
        LocalizedLabelInfo _x = new LocalizedLabelInfo();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields;
        _x.odataType = this.odataType;
        _x.label = this.label;
        _x.languageCode = this.languageCode;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LocalizedLabelInfo[");
        b.append("Label=");
        b.append(this.label);
        b.append(", ");
        b.append("LanguageCode=");
        b.append(this.languageCode);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private String label;
        private Integer languageCode;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder label(String label) {
            this.label = label;
            this.changedFields = this.changedFields.add("Label");
            return this;
        }

        public Builder languageCode(Integer languageCode) {
            this.languageCode = languageCode;
            this.changedFields = this.changedFields.add("LanguageCode");
            return this;
        }

        public LocalizedLabelInfo build() {
            LocalizedLabelInfo _x = new LocalizedLabelInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "Microsoft.Dynamics.CRM.LocalizedLabelInfo";
            _x.label = this.label;
            _x.languageCode = this.languageCode;
            return _x;
        }
    }
}

