/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import microsoft.dynamics.crm.complex.Object;
import microsoft.dynamics.crm.complex.SolutionInfo;
import microsoft.dynamics.crm.enums.LayerDesiredOrderType;
import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonPropertyOrder(value={"@odata.type", "Type", "Solutions"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class LayerDesiredOrder
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="Type")
    protected LayerDesiredOrderType type;
    @JsonProperty(value="Solutions")
    protected List<SolutionInfo> solutions;
    @JsonProperty(value="Solutions@nextLink")
    protected String solutionsNextLink;

    protected LayerDesiredOrder() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.LayerDesiredOrder";
    }

    @Property(name="Type")
    @JsonIgnore
    public Optional<LayerDesiredOrderType> getType() {
        return Optional.ofNullable(this.type);
    }

    public LayerDesiredOrder withType(LayerDesiredOrderType type) {
        LayerDesiredOrder _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.LayerDesiredOrder");
        _x.type = type;
        return _x;
    }

    @Property(name="Solutions")
    @JsonIgnore
    public CollectionPage<SolutionInfo> getSolutions() {
        return new CollectionPage(this.contextPath, SolutionInfo.class, this.solutions, Optional.ofNullable(this.solutionsNextLink), (com.github.davidmoten.odata.client.SchemaInfo)SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Solutions")
    @JsonIgnore
    public CollectionPage<SolutionInfo> getSolutions(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, SolutionInfo.class, this.solutions, Optional.ofNullable(this.solutionsNextLink), (com.github.davidmoten.odata.client.SchemaInfo)SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFields();
        }
        this.unmappedFields.put(name, (java.lang.Object)value);
    }

    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields == null ? UnmappedFields.EMPTY : this.unmappedFields;
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private LayerDesiredOrder _copy() {
        LayerDesiredOrder _x = new LayerDesiredOrder();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields;
        _x.odataType = this.odataType;
        _x.type = this.type;
        _x.solutions = this.solutions;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LayerDesiredOrder[");
        b.append("Type=");
        b.append((java.lang.Object)this.type);
        b.append(", ");
        b.append("Solutions=");
        b.append(this.solutions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private LayerDesiredOrderType type;
        private List<SolutionInfo> solutions;
        private String solutionsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder type(LayerDesiredOrderType type) {
            this.type = type;
            this.changedFields = this.changedFields.add("Type");
            return this;
        }

        public Builder solutions(List<SolutionInfo> solutions) {
            this.solutions = solutions;
            this.changedFields = this.changedFields.add("Solutions");
            return this;
        }

        public Builder solutions(SolutionInfo ... solutions) {
            return this.solutions(Arrays.asList(solutions));
        }

        public Builder solutionsNextLink(String solutionsNextLink) {
            this.solutionsNextLink = solutionsNextLink;
            this.changedFields = this.changedFields.add("Solutions");
            return this;
        }

        public LayerDesiredOrder build() {
            LayerDesiredOrder _x = new LayerDesiredOrder();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "Microsoft.Dynamics.CRM.LayerDesiredOrder";
            _x.type = this.type;
            _x.solutions = this.solutions;
            _x.solutionsNextLink = this.solutionsNextLink;
            return _x;
        }
    }
}

