/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import java.util.Optional;
import microsoft.dynamics.crm.complex.Object;

@JsonPropertyOrder(value={"@odata.type", "Order", "FormId", "Name", "IsCustomizable"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FormDisplayOrder
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="Order")
    protected Integer order;
    @JsonProperty(value="FormId")
    protected String formId;
    @JsonProperty(value="Name")
    protected String name;
    @JsonProperty(value="IsCustomizable")
    protected Boolean isCustomizable;

    protected FormDisplayOrder() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.FormDisplayOrder";
    }

    @Property(name="Order")
    @JsonIgnore
    public Optional<Integer> getOrder() {
        return Optional.ofNullable(this.order);
    }

    public FormDisplayOrder withOrder(Integer order) {
        FormDisplayOrder _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.FormDisplayOrder");
        _x.order = order;
        return _x;
    }

    @Property(name="FormId")
    @JsonIgnore
    public Optional<String> getFormId() {
        return Optional.ofNullable(this.formId);
    }

    public FormDisplayOrder withFormId(String formId) {
        FormDisplayOrder _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.FormDisplayOrder");
        _x.formId = formId;
        return _x;
    }

    @Property(name="Name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public FormDisplayOrder withName(String name) {
        Checks.checkIsAscii((String)name);
        FormDisplayOrder _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.FormDisplayOrder");
        _x.name = name;
        return _x;
    }

    @Property(name="IsCustomizable")
    @JsonIgnore
    public Optional<Boolean> getIsCustomizable() {
        return Optional.ofNullable(this.isCustomizable);
    }

    public FormDisplayOrder withIsCustomizable(Boolean isCustomizable) {
        FormDisplayOrder _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.FormDisplayOrder");
        _x.isCustomizable = isCustomizable;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFields();
        }
        this.unmappedFields.put(name, (java.lang.Object)value);
    }

    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields == null ? UnmappedFields.EMPTY : this.unmappedFields;
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private FormDisplayOrder _copy() {
        FormDisplayOrder _x = new FormDisplayOrder();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields;
        _x.odataType = this.odataType;
        _x.order = this.order;
        _x.formId = this.formId;
        _x.name = this.name;
        _x.isCustomizable = this.isCustomizable;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("FormDisplayOrder[");
        b.append("Order=");
        b.append(this.order);
        b.append(", ");
        b.append("FormId=");
        b.append(this.formId);
        b.append(", ");
        b.append("Name=");
        b.append(this.name);
        b.append(", ");
        b.append("IsCustomizable=");
        b.append(this.isCustomizable);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private Integer order;
        private String formId;
        private String name;
        private Boolean isCustomizable;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder order(Integer order) {
            this.order = order;
            this.changedFields = this.changedFields.add("Order");
            return this;
        }

        public Builder formId(String formId) {
            this.formId = formId;
            this.changedFields = this.changedFields.add("FormId");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = this.changedFields.add("Name");
            return this;
        }

        public Builder isCustomizable(Boolean isCustomizable) {
            this.isCustomizable = isCustomizable;
            this.changedFields = this.changedFields.add("IsCustomizable");
            return this;
        }

        public FormDisplayOrder build() {
            FormDisplayOrder _x = new FormDisplayOrder();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "Microsoft.Dynamics.CRM.FormDisplayOrder";
            _x.order = this.order;
            _x.formId = this.formId;
            _x.name = this.name;
            _x.isCustomizable = this.isCustomizable;
            return _x;
        }
    }
}

