/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import java.util.Optional;
import microsoft.dynamics.crm.complex.DependentAttributeMetadataCollection;
import microsoft.dynamics.crm.complex.DependentEntityMetadataCollection;
import microsoft.dynamics.crm.complex.DependentRelationshipCollection;
import microsoft.dynamics.crm.complex.Object;

@JsonPropertyOrder(value={"@odata.type", "EntityId", "LogicalName", "LogicalCollectionName", "ObjectTypeCode", "DisplayName", "PrimaryNameAttribute", "PrimaryIdAttribute", "AttributesMetadata", "EntityRelationshipCollection", "DependantEntitiesCollection"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class EntityRelationsWithDependantEntityMetadata
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="EntityId")
    protected String entityId;
    @JsonProperty(value="LogicalName")
    protected String logicalName;
    @JsonProperty(value="LogicalCollectionName")
    protected String logicalCollectionName;
    @JsonProperty(value="ObjectTypeCode")
    protected Integer objectTypeCode;
    @JsonProperty(value="DisplayName")
    protected String displayName;
    @JsonProperty(value="PrimaryNameAttribute")
    protected String primaryNameAttribute;
    @JsonProperty(value="PrimaryIdAttribute")
    protected String primaryIdAttribute;
    @JsonProperty(value="AttributesMetadata")
    protected DependentAttributeMetadataCollection attributesMetadata;
    @JsonProperty(value="EntityRelationshipCollection")
    protected DependentRelationshipCollection entityRelationshipCollection;
    @JsonProperty(value="DependantEntitiesCollection")
    protected DependentEntityMetadataCollection dependantEntitiesCollection;

    protected EntityRelationsWithDependantEntityMetadata() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.EntityRelationsWithDependantEntityMetadata";
    }

    @Property(name="EntityId")
    @JsonIgnore
    public Optional<String> getEntityId() {
        return Optional.ofNullable(this.entityId);
    }

    public EntityRelationsWithDependantEntityMetadata withEntityId(String entityId) {
        Checks.checkIsAscii((String)entityId);
        EntityRelationsWithDependantEntityMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.EntityRelationsWithDependantEntityMetadata");
        _x.entityId = entityId;
        return _x;
    }

    @Property(name="LogicalName")
    @JsonIgnore
    public Optional<String> getLogicalName() {
        return Optional.ofNullable(this.logicalName);
    }

    public EntityRelationsWithDependantEntityMetadata withLogicalName(String logicalName) {
        Checks.checkIsAscii((String)logicalName);
        EntityRelationsWithDependantEntityMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.EntityRelationsWithDependantEntityMetadata");
        _x.logicalName = logicalName;
        return _x;
    }

    @Property(name="LogicalCollectionName")
    @JsonIgnore
    public Optional<String> getLogicalCollectionName() {
        return Optional.ofNullable(this.logicalCollectionName);
    }

    public EntityRelationsWithDependantEntityMetadata withLogicalCollectionName(String logicalCollectionName) {
        Checks.checkIsAscii((String)logicalCollectionName);
        EntityRelationsWithDependantEntityMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.EntityRelationsWithDependantEntityMetadata");
        _x.logicalCollectionName = logicalCollectionName;
        return _x;
    }

    @Property(name="ObjectTypeCode")
    @JsonIgnore
    public Optional<Integer> getObjectTypeCode() {
        return Optional.ofNullable(this.objectTypeCode);
    }

    public EntityRelationsWithDependantEntityMetadata withObjectTypeCode(Integer objectTypeCode) {
        EntityRelationsWithDependantEntityMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.EntityRelationsWithDependantEntityMetadata");
        _x.objectTypeCode = objectTypeCode;
        return _x;
    }

    @Property(name="DisplayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(this.displayName);
    }

    public EntityRelationsWithDependantEntityMetadata withDisplayName(String displayName) {
        Checks.checkIsAscii((String)displayName);
        EntityRelationsWithDependantEntityMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.EntityRelationsWithDependantEntityMetadata");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="PrimaryNameAttribute")
    @JsonIgnore
    public Optional<String> getPrimaryNameAttribute() {
        return Optional.ofNullable(this.primaryNameAttribute);
    }

    public EntityRelationsWithDependantEntityMetadata withPrimaryNameAttribute(String primaryNameAttribute) {
        Checks.checkIsAscii((String)primaryNameAttribute);
        EntityRelationsWithDependantEntityMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.EntityRelationsWithDependantEntityMetadata");
        _x.primaryNameAttribute = primaryNameAttribute;
        return _x;
    }

    @Property(name="PrimaryIdAttribute")
    @JsonIgnore
    public Optional<String> getPrimaryIdAttribute() {
        return Optional.ofNullable(this.primaryIdAttribute);
    }

    public EntityRelationsWithDependantEntityMetadata withPrimaryIdAttribute(String primaryIdAttribute) {
        Checks.checkIsAscii((String)primaryIdAttribute);
        EntityRelationsWithDependantEntityMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.EntityRelationsWithDependantEntityMetadata");
        _x.primaryIdAttribute = primaryIdAttribute;
        return _x;
    }

    @Property(name="AttributesMetadata")
    @JsonIgnore
    public Optional<DependentAttributeMetadataCollection> getAttributesMetadata() {
        return Optional.ofNullable(this.attributesMetadata);
    }

    public EntityRelationsWithDependantEntityMetadata withAttributesMetadata(DependentAttributeMetadataCollection attributesMetadata) {
        EntityRelationsWithDependantEntityMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.EntityRelationsWithDependantEntityMetadata");
        _x.attributesMetadata = attributesMetadata;
        return _x;
    }

    @Property(name="EntityRelationshipCollection")
    @JsonIgnore
    public Optional<DependentRelationshipCollection> getEntityRelationshipCollection() {
        return Optional.ofNullable(this.entityRelationshipCollection);
    }

    public EntityRelationsWithDependantEntityMetadata withEntityRelationshipCollection(DependentRelationshipCollection entityRelationshipCollection) {
        EntityRelationsWithDependantEntityMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.EntityRelationsWithDependantEntityMetadata");
        _x.entityRelationshipCollection = entityRelationshipCollection;
        return _x;
    }

    @Property(name="DependantEntitiesCollection")
    @JsonIgnore
    public Optional<DependentEntityMetadataCollection> getDependantEntitiesCollection() {
        return Optional.ofNullable(this.dependantEntitiesCollection);
    }

    public EntityRelationsWithDependantEntityMetadata withDependantEntitiesCollection(DependentEntityMetadataCollection dependantEntitiesCollection) {
        EntityRelationsWithDependantEntityMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.EntityRelationsWithDependantEntityMetadata");
        _x.dependantEntitiesCollection = dependantEntitiesCollection;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFields();
        }
        this.unmappedFields.put(name, (java.lang.Object)value);
    }

    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields == null ? UnmappedFields.EMPTY : this.unmappedFields;
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private EntityRelationsWithDependantEntityMetadata _copy() {
        EntityRelationsWithDependantEntityMetadata _x = new EntityRelationsWithDependantEntityMetadata();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields;
        _x.odataType = this.odataType;
        _x.entityId = this.entityId;
        _x.logicalName = this.logicalName;
        _x.logicalCollectionName = this.logicalCollectionName;
        _x.objectTypeCode = this.objectTypeCode;
        _x.displayName = this.displayName;
        _x.primaryNameAttribute = this.primaryNameAttribute;
        _x.primaryIdAttribute = this.primaryIdAttribute;
        _x.attributesMetadata = this.attributesMetadata;
        _x.entityRelationshipCollection = this.entityRelationshipCollection;
        _x.dependantEntitiesCollection = this.dependantEntitiesCollection;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EntityRelationsWithDependantEntityMetadata[");
        b.append("EntityId=");
        b.append(this.entityId);
        b.append(", ");
        b.append("LogicalName=");
        b.append(this.logicalName);
        b.append(", ");
        b.append("LogicalCollectionName=");
        b.append(this.logicalCollectionName);
        b.append(", ");
        b.append("ObjectTypeCode=");
        b.append(this.objectTypeCode);
        b.append(", ");
        b.append("DisplayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("PrimaryNameAttribute=");
        b.append(this.primaryNameAttribute);
        b.append(", ");
        b.append("PrimaryIdAttribute=");
        b.append(this.primaryIdAttribute);
        b.append(", ");
        b.append("AttributesMetadata=");
        b.append(this.attributesMetadata);
        b.append(", ");
        b.append("EntityRelationshipCollection=");
        b.append(this.entityRelationshipCollection);
        b.append(", ");
        b.append("DependantEntitiesCollection=");
        b.append(this.dependantEntitiesCollection);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private String entityId;
        private String logicalName;
        private String logicalCollectionName;
        private Integer objectTypeCode;
        private String displayName;
        private String primaryNameAttribute;
        private String primaryIdAttribute;
        private DependentAttributeMetadataCollection attributesMetadata;
        private DependentRelationshipCollection entityRelationshipCollection;
        private DependentEntityMetadataCollection dependantEntitiesCollection;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder entityId(String entityId) {
            this.entityId = entityId;
            this.changedFields = this.changedFields.add("EntityId");
            return this;
        }

        public Builder logicalName(String logicalName) {
            this.logicalName = logicalName;
            this.changedFields = this.changedFields.add("LogicalName");
            return this;
        }

        public Builder logicalCollectionName(String logicalCollectionName) {
            this.logicalCollectionName = logicalCollectionName;
            this.changedFields = this.changedFields.add("LogicalCollectionName");
            return this;
        }

        public Builder objectTypeCode(Integer objectTypeCode) {
            this.objectTypeCode = objectTypeCode;
            this.changedFields = this.changedFields.add("ObjectTypeCode");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = this.changedFields.add("DisplayName");
            return this;
        }

        public Builder primaryNameAttribute(String primaryNameAttribute) {
            this.primaryNameAttribute = primaryNameAttribute;
            this.changedFields = this.changedFields.add("PrimaryNameAttribute");
            return this;
        }

        public Builder primaryIdAttribute(String primaryIdAttribute) {
            this.primaryIdAttribute = primaryIdAttribute;
            this.changedFields = this.changedFields.add("PrimaryIdAttribute");
            return this;
        }

        public Builder attributesMetadata(DependentAttributeMetadataCollection attributesMetadata) {
            this.attributesMetadata = attributesMetadata;
            this.changedFields = this.changedFields.add("AttributesMetadata");
            return this;
        }

        public Builder entityRelationshipCollection(DependentRelationshipCollection entityRelationshipCollection) {
            this.entityRelationshipCollection = entityRelationshipCollection;
            this.changedFields = this.changedFields.add("EntityRelationshipCollection");
            return this;
        }

        public Builder dependantEntitiesCollection(DependentEntityMetadataCollection dependantEntitiesCollection) {
            this.dependantEntitiesCollection = dependantEntitiesCollection;
            this.changedFields = this.changedFields.add("DependantEntitiesCollection");
            return this;
        }

        public EntityRelationsWithDependantEntityMetadata build() {
            EntityRelationsWithDependantEntityMetadata _x = new EntityRelationsWithDependantEntityMetadata();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "Microsoft.Dynamics.CRM.EntityRelationsWithDependantEntityMetadata";
            _x.entityId = this.entityId;
            _x.logicalName = this.logicalName;
            _x.logicalCollectionName = this.logicalCollectionName;
            _x.objectTypeCode = this.objectTypeCode;
            _x.displayName = this.displayName;
            _x.primaryNameAttribute = this.primaryNameAttribute;
            _x.primaryIdAttribute = this.primaryIdAttribute;
            _x.attributesMetadata = this.attributesMetadata;
            _x.entityRelationshipCollection = this.entityRelationshipCollection;
            _x.dependantEntitiesCollection = this.dependantEntitiesCollection;
            return _x;
        }
    }
}

