/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import java.util.Optional;
import microsoft.dynamics.crm.complex.AttributeQueryExpression;
import microsoft.dynamics.crm.complex.EntityKeyQueryExpression;
import microsoft.dynamics.crm.complex.LabelQueryExpression;
import microsoft.dynamics.crm.complex.MetadataFilterExpression;
import microsoft.dynamics.crm.complex.MetadataPropertiesExpression;
import microsoft.dynamics.crm.complex.Object;
import microsoft.dynamics.crm.complex.RelationshipQueryExpression;

@JsonPropertyOrder(value={"@odata.type", "LabelQuery", "AttributeQuery", "RelationshipQuery", "KeyQuery", "Criteria", "Properties"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class EntityQueryExpression
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="LabelQuery")
    protected LabelQueryExpression labelQuery;
    @JsonProperty(value="AttributeQuery")
    protected AttributeQueryExpression attributeQuery;
    @JsonProperty(value="RelationshipQuery")
    protected RelationshipQueryExpression relationshipQuery;
    @JsonProperty(value="KeyQuery")
    protected EntityKeyQueryExpression keyQuery;
    @JsonProperty(value="Criteria")
    protected MetadataFilterExpression criteria;
    @JsonProperty(value="Properties")
    protected MetadataPropertiesExpression properties;

    protected EntityQueryExpression() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.EntityQueryExpression";
    }

    @Property(name="LabelQuery")
    @JsonIgnore
    public Optional<LabelQueryExpression> getLabelQuery() {
        return Optional.ofNullable(this.labelQuery);
    }

    public EntityQueryExpression withLabelQuery(LabelQueryExpression labelQuery) {
        EntityQueryExpression _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.EntityQueryExpression");
        _x.labelQuery = labelQuery;
        return _x;
    }

    @Property(name="AttributeQuery")
    @JsonIgnore
    public Optional<AttributeQueryExpression> getAttributeQuery() {
        return Optional.ofNullable(this.attributeQuery);
    }

    public EntityQueryExpression withAttributeQuery(AttributeQueryExpression attributeQuery) {
        EntityQueryExpression _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.EntityQueryExpression");
        _x.attributeQuery = attributeQuery;
        return _x;
    }

    @Property(name="RelationshipQuery")
    @JsonIgnore
    public Optional<RelationshipQueryExpression> getRelationshipQuery() {
        return Optional.ofNullable(this.relationshipQuery);
    }

    public EntityQueryExpression withRelationshipQuery(RelationshipQueryExpression relationshipQuery) {
        EntityQueryExpression _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.EntityQueryExpression");
        _x.relationshipQuery = relationshipQuery;
        return _x;
    }

    @Property(name="KeyQuery")
    @JsonIgnore
    public Optional<EntityKeyQueryExpression> getKeyQuery() {
        return Optional.ofNullable(this.keyQuery);
    }

    public EntityQueryExpression withKeyQuery(EntityKeyQueryExpression keyQuery) {
        EntityQueryExpression _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.EntityQueryExpression");
        _x.keyQuery = keyQuery;
        return _x;
    }

    @Property(name="Criteria")
    @JsonIgnore
    public Optional<MetadataFilterExpression> getCriteria() {
        return Optional.ofNullable(this.criteria);
    }

    public EntityQueryExpression withCriteria(MetadataFilterExpression criteria) {
        EntityQueryExpression _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.EntityQueryExpression");
        _x.criteria = criteria;
        return _x;
    }

    @Property(name="Properties")
    @JsonIgnore
    public Optional<MetadataPropertiesExpression> getProperties() {
        return Optional.ofNullable(this.properties);
    }

    public EntityQueryExpression withProperties(MetadataPropertiesExpression properties) {
        EntityQueryExpression _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.EntityQueryExpression");
        _x.properties = properties;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFields();
        }
        this.unmappedFields.put(name, (java.lang.Object)value);
    }

    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields == null ? UnmappedFields.EMPTY : this.unmappedFields;
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private EntityQueryExpression _copy() {
        EntityQueryExpression _x = new EntityQueryExpression();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields;
        _x.odataType = this.odataType;
        _x.labelQuery = this.labelQuery;
        _x.attributeQuery = this.attributeQuery;
        _x.relationshipQuery = this.relationshipQuery;
        _x.keyQuery = this.keyQuery;
        _x.criteria = this.criteria;
        _x.properties = this.properties;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EntityQueryExpression[");
        b.append("LabelQuery=");
        b.append(this.labelQuery);
        b.append(", ");
        b.append("AttributeQuery=");
        b.append(this.attributeQuery);
        b.append(", ");
        b.append("RelationshipQuery=");
        b.append(this.relationshipQuery);
        b.append(", ");
        b.append("KeyQuery=");
        b.append(this.keyQuery);
        b.append(", ");
        b.append("Criteria=");
        b.append(this.criteria);
        b.append(", ");
        b.append("Properties=");
        b.append(this.properties);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private LabelQueryExpression labelQuery;
        private AttributeQueryExpression attributeQuery;
        private RelationshipQueryExpression relationshipQuery;
        private EntityKeyQueryExpression keyQuery;
        private MetadataFilterExpression criteria;
        private MetadataPropertiesExpression properties;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder labelQuery(LabelQueryExpression labelQuery) {
            this.labelQuery = labelQuery;
            this.changedFields = this.changedFields.add("LabelQuery");
            return this;
        }

        public Builder attributeQuery(AttributeQueryExpression attributeQuery) {
            this.attributeQuery = attributeQuery;
            this.changedFields = this.changedFields.add("AttributeQuery");
            return this;
        }

        public Builder relationshipQuery(RelationshipQueryExpression relationshipQuery) {
            this.relationshipQuery = relationshipQuery;
            this.changedFields = this.changedFields.add("RelationshipQuery");
            return this;
        }

        public Builder keyQuery(EntityKeyQueryExpression keyQuery) {
            this.keyQuery = keyQuery;
            this.changedFields = this.changedFields.add("KeyQuery");
            return this;
        }

        public Builder criteria(MetadataFilterExpression criteria) {
            this.criteria = criteria;
            this.changedFields = this.changedFields.add("Criteria");
            return this;
        }

        public Builder properties(MetadataPropertiesExpression properties) {
            this.properties = properties;
            this.changedFields = this.changedFields.add("Properties");
            return this;
        }

        public EntityQueryExpression build() {
            EntityQueryExpression _x = new EntityQueryExpression();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "Microsoft.Dynamics.CRM.EntityQueryExpression";
            _x.labelQuery = this.labelQuery;
            _x.attributeQuery = this.attributeQuery;
            _x.relationshipQuery = this.relationshipQuery;
            _x.keyQuery = this.keyQuery;
            _x.criteria = this.criteria;
            _x.properties = this.properties;
            return _x;
        }
    }
}

