/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import java.util.Optional;
import microsoft.dynamics.crm.complex.Object;

@JsonPropertyOrder(value={"@odata.type", "ObjectId", "ConstraintType", "Constraints"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ConstraintRelation
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="ObjectId")
    protected String objectId;
    @JsonProperty(value="ConstraintType")
    protected String constraintType;
    @JsonProperty(value="Constraints")
    protected String constraints;

    protected ConstraintRelation() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ConstraintRelation";
    }

    @Property(name="ObjectId")
    @JsonIgnore
    public Optional<String> getObjectId() {
        return Optional.ofNullable(this.objectId);
    }

    public ConstraintRelation withObjectId(String objectId) {
        ConstraintRelation _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.ConstraintRelation");
        _x.objectId = objectId;
        return _x;
    }

    @Property(name="ConstraintType")
    @JsonIgnore
    public Optional<String> getConstraintType() {
        return Optional.ofNullable(this.constraintType);
    }

    public ConstraintRelation withConstraintType(String constraintType) {
        Checks.checkIsAscii((String)constraintType);
        ConstraintRelation _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.ConstraintRelation");
        _x.constraintType = constraintType;
        return _x;
    }

    @Property(name="Constraints")
    @JsonIgnore
    public Optional<String> getConstraints() {
        return Optional.ofNullable(this.constraints);
    }

    public ConstraintRelation withConstraints(String constraints) {
        Checks.checkIsAscii((String)constraints);
        ConstraintRelation _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.ConstraintRelation");
        _x.constraints = constraints;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFields();
        }
        this.unmappedFields.put(name, (java.lang.Object)value);
    }

    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields == null ? UnmappedFields.EMPTY : this.unmappedFields;
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private ConstraintRelation _copy() {
        ConstraintRelation _x = new ConstraintRelation();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields;
        _x.odataType = this.odataType;
        _x.objectId = this.objectId;
        _x.constraintType = this.constraintType;
        _x.constraints = this.constraints;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ConstraintRelation[");
        b.append("ObjectId=");
        b.append(this.objectId);
        b.append(", ");
        b.append("ConstraintType=");
        b.append(this.constraintType);
        b.append(", ");
        b.append("Constraints=");
        b.append(this.constraints);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private String objectId;
        private String constraintType;
        private String constraints;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder objectId(String objectId) {
            this.objectId = objectId;
            this.changedFields = this.changedFields.add("ObjectId");
            return this;
        }

        public Builder constraintType(String constraintType) {
            this.constraintType = constraintType;
            this.changedFields = this.changedFields.add("ConstraintType");
            return this;
        }

        public Builder constraints(String constraints) {
            this.constraints = constraints;
            this.changedFields = this.changedFields.add("Constraints");
            return this;
        }

        public ConstraintRelation build() {
            ConstraintRelation _x = new ConstraintRelation();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "Microsoft.Dynamics.CRM.ConstraintRelation";
            _x.objectId = this.objectId;
            _x.constraintType = this.constraintType;
            _x.constraints = this.constraints;
            return _x;
        }
    }
}

