/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import java.util.Optional;
import microsoft.dynamics.crm.complex.Object;

@JsonPropertyOrder(value={"@odata.type", "Type", "SchemaName", "DisplayName", "Id", "ParentSchemaName", "ParentDisplayName", "ParentId", "Solution"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ComponentDetail
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="Type")
    protected Integer type;
    @JsonProperty(value="SchemaName")
    protected String schemaName;
    @JsonProperty(value="DisplayName")
    protected String displayName;
    @JsonProperty(value="Id")
    protected String id;
    @JsonProperty(value="ParentSchemaName")
    protected String parentSchemaName;
    @JsonProperty(value="ParentDisplayName")
    protected String parentDisplayName;
    @JsonProperty(value="ParentId")
    protected String parentId;
    @JsonProperty(value="Solution")
    protected String solution;

    protected ComponentDetail() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ComponentDetail";
    }

    @Property(name="Type")
    @JsonIgnore
    public Optional<Integer> getType() {
        return Optional.ofNullable(this.type);
    }

    public ComponentDetail withType(Integer type) {
        ComponentDetail _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.ComponentDetail");
        _x.type = type;
        return _x;
    }

    @Property(name="SchemaName")
    @JsonIgnore
    public Optional<String> getSchemaName() {
        return Optional.ofNullable(this.schemaName);
    }

    public ComponentDetail withSchemaName(String schemaName) {
        Checks.checkIsAscii((String)schemaName);
        ComponentDetail _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.ComponentDetail");
        _x.schemaName = schemaName;
        return _x;
    }

    @Property(name="DisplayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(this.displayName);
    }

    public ComponentDetail withDisplayName(String displayName) {
        Checks.checkIsAscii((String)displayName);
        ComponentDetail _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.ComponentDetail");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="Id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(this.id);
    }

    public ComponentDetail withId(String id) {
        ComponentDetail _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.ComponentDetail");
        _x.id = id;
        return _x;
    }

    @Property(name="ParentSchemaName")
    @JsonIgnore
    public Optional<String> getParentSchemaName() {
        return Optional.ofNullable(this.parentSchemaName);
    }

    public ComponentDetail withParentSchemaName(String parentSchemaName) {
        Checks.checkIsAscii((String)parentSchemaName);
        ComponentDetail _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.ComponentDetail");
        _x.parentSchemaName = parentSchemaName;
        return _x;
    }

    @Property(name="ParentDisplayName")
    @JsonIgnore
    public Optional<String> getParentDisplayName() {
        return Optional.ofNullable(this.parentDisplayName);
    }

    public ComponentDetail withParentDisplayName(String parentDisplayName) {
        Checks.checkIsAscii((String)parentDisplayName);
        ComponentDetail _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.ComponentDetail");
        _x.parentDisplayName = parentDisplayName;
        return _x;
    }

    @Property(name="ParentId")
    @JsonIgnore
    public Optional<String> getParentId() {
        return Optional.ofNullable(this.parentId);
    }

    public ComponentDetail withParentId(String parentId) {
        ComponentDetail _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.ComponentDetail");
        _x.parentId = parentId;
        return _x;
    }

    @Property(name="Solution")
    @JsonIgnore
    public Optional<String> getSolution() {
        return Optional.ofNullable(this.solution);
    }

    public ComponentDetail withSolution(String solution) {
        Checks.checkIsAscii((String)solution);
        ComponentDetail _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.ComponentDetail");
        _x.solution = solution;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFields();
        }
        this.unmappedFields.put(name, (java.lang.Object)value);
    }

    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields == null ? UnmappedFields.EMPTY : this.unmappedFields;
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private ComponentDetail _copy() {
        ComponentDetail _x = new ComponentDetail();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields;
        _x.odataType = this.odataType;
        _x.type = this.type;
        _x.schemaName = this.schemaName;
        _x.displayName = this.displayName;
        _x.id = this.id;
        _x.parentSchemaName = this.parentSchemaName;
        _x.parentDisplayName = this.parentDisplayName;
        _x.parentId = this.parentId;
        _x.solution = this.solution;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ComponentDetail[");
        b.append("Type=");
        b.append(this.type);
        b.append(", ");
        b.append("SchemaName=");
        b.append(this.schemaName);
        b.append(", ");
        b.append("DisplayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("Id=");
        b.append(this.id);
        b.append(", ");
        b.append("ParentSchemaName=");
        b.append(this.parentSchemaName);
        b.append(", ");
        b.append("ParentDisplayName=");
        b.append(this.parentDisplayName);
        b.append(", ");
        b.append("ParentId=");
        b.append(this.parentId);
        b.append(", ");
        b.append("Solution=");
        b.append(this.solution);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private Integer type;
        private String schemaName;
        private String displayName;
        private String id;
        private String parentSchemaName;
        private String parentDisplayName;
        private String parentId;
        private String solution;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder type(Integer type) {
            this.type = type;
            this.changedFields = this.changedFields.add("Type");
            return this;
        }

        public Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            this.changedFields = this.changedFields.add("SchemaName");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = this.changedFields.add("DisplayName");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = this.changedFields.add("Id");
            return this;
        }

        public Builder parentSchemaName(String parentSchemaName) {
            this.parentSchemaName = parentSchemaName;
            this.changedFields = this.changedFields.add("ParentSchemaName");
            return this;
        }

        public Builder parentDisplayName(String parentDisplayName) {
            this.parentDisplayName = parentDisplayName;
            this.changedFields = this.changedFields.add("ParentDisplayName");
            return this;
        }

        public Builder parentId(String parentId) {
            this.parentId = parentId;
            this.changedFields = this.changedFields.add("ParentId");
            return this;
        }

        public Builder solution(String solution) {
            this.solution = solution;
            this.changedFields = this.changedFields.add("Solution");
            return this;
        }

        public ComponentDetail build() {
            ComponentDetail _x = new ComponentDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "Microsoft.Dynamics.CRM.ComponentDetail";
            _x.type = this.type;
            _x.schemaName = this.schemaName;
            _x.displayName = this.displayName;
            _x.id = this.id;
            _x.parentSchemaName = this.parentSchemaName;
            _x.parentDisplayName = this.parentDisplayName;
            _x.parentId = this.parentId;
            _x.solution = this.solution;
            return _x;
        }
    }
}

