/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import microsoft.dynamics.crm.complex.AppSettingDetails;
import microsoft.dynamics.crm.complex.Object;
import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonPropertyOrder(value={"@odata.type", "AppId", "AppDisplayName", "PublisherName", "PublishedOn", "AppUniqueName", "AppVersion", "Description", "WebResourceUri", "WelcomePageUri", "CreatedOn", "CreatedBy", "ModifiedOn", "ModifiedBy", "AppUri", "IsDefault", "ClientType", "NavigationType", "OptimizedFor", "AppSettingDetails"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AppModuleInfo
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="AppId")
    protected String appId;
    @JsonProperty(value="AppDisplayName")
    protected String appDisplayName;
    @JsonProperty(value="PublisherName")
    protected String publisherName;
    @JsonProperty(value="PublishedOn")
    protected String publishedOn;
    @JsonProperty(value="AppUniqueName")
    protected String appUniqueName;
    @JsonProperty(value="AppVersion")
    protected String appVersion;
    @JsonProperty(value="Description")
    protected String description;
    @JsonProperty(value="WebResourceUri")
    protected String webResourceUri;
    @JsonProperty(value="WelcomePageUri")
    protected String welcomePageUri;
    @JsonProperty(value="CreatedOn")
    protected String createdOn;
    @JsonProperty(value="CreatedBy")
    protected String createdBy;
    @JsonProperty(value="ModifiedOn")
    protected String modifiedOn;
    @JsonProperty(value="ModifiedBy")
    protected String modifiedBy;
    @JsonProperty(value="AppUri")
    protected String appUri;
    @JsonProperty(value="IsDefault")
    protected Boolean isDefault;
    @JsonProperty(value="ClientType")
    protected Integer clientType;
    @JsonProperty(value="NavigationType")
    protected Integer navigationType;
    @JsonProperty(value="OptimizedFor")
    protected String optimizedFor;
    @JsonProperty(value="AppSettingDetails")
    protected List<AppSettingDetails> appSettingDetails;
    @JsonProperty(value="AppSettingDetails@nextLink")
    protected String appSettingDetailsNextLink;

    protected AppModuleInfo() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.AppModuleInfo";
    }

    @Property(name="AppId")
    @JsonIgnore
    public Optional<String> getAppId() {
        return Optional.ofNullable(this.appId);
    }

    public AppModuleInfo withAppId(String appId) {
        Checks.checkIsAscii((String)appId);
        AppModuleInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.AppModuleInfo");
        _x.appId = appId;
        return _x;
    }

    @Property(name="AppDisplayName")
    @JsonIgnore
    public Optional<String> getAppDisplayName() {
        return Optional.ofNullable(this.appDisplayName);
    }

    public AppModuleInfo withAppDisplayName(String appDisplayName) {
        Checks.checkIsAscii((String)appDisplayName);
        AppModuleInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.AppModuleInfo");
        _x.appDisplayName = appDisplayName;
        return _x;
    }

    @Property(name="PublisherName")
    @JsonIgnore
    public Optional<String> getPublisherName() {
        return Optional.ofNullable(this.publisherName);
    }

    public AppModuleInfo withPublisherName(String publisherName) {
        Checks.checkIsAscii((String)publisherName);
        AppModuleInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.AppModuleInfo");
        _x.publisherName = publisherName;
        return _x;
    }

    @Property(name="PublishedOn")
    @JsonIgnore
    public Optional<String> getPublishedOn() {
        return Optional.ofNullable(this.publishedOn);
    }

    public AppModuleInfo withPublishedOn(String publishedOn) {
        Checks.checkIsAscii((String)publishedOn);
        AppModuleInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.AppModuleInfo");
        _x.publishedOn = publishedOn;
        return _x;
    }

    @Property(name="AppUniqueName")
    @JsonIgnore
    public Optional<String> getAppUniqueName() {
        return Optional.ofNullable(this.appUniqueName);
    }

    public AppModuleInfo withAppUniqueName(String appUniqueName) {
        Checks.checkIsAscii((String)appUniqueName);
        AppModuleInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.AppModuleInfo");
        _x.appUniqueName = appUniqueName;
        return _x;
    }

    @Property(name="AppVersion")
    @JsonIgnore
    public Optional<String> getAppVersion() {
        return Optional.ofNullable(this.appVersion);
    }

    public AppModuleInfo withAppVersion(String appVersion) {
        Checks.checkIsAscii((String)appVersion);
        AppModuleInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.AppModuleInfo");
        _x.appVersion = appVersion;
        return _x;
    }

    @Property(name="Description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public AppModuleInfo withDescription(String description) {
        Checks.checkIsAscii((String)description);
        AppModuleInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.AppModuleInfo");
        _x.description = description;
        return _x;
    }

    @Property(name="WebResourceUri")
    @JsonIgnore
    public Optional<String> getWebResourceUri() {
        return Optional.ofNullable(this.webResourceUri);
    }

    public AppModuleInfo withWebResourceUri(String webResourceUri) {
        Checks.checkIsAscii((String)webResourceUri);
        AppModuleInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.AppModuleInfo");
        _x.webResourceUri = webResourceUri;
        return _x;
    }

    @Property(name="WelcomePageUri")
    @JsonIgnore
    public Optional<String> getWelcomePageUri() {
        return Optional.ofNullable(this.welcomePageUri);
    }

    public AppModuleInfo withWelcomePageUri(String welcomePageUri) {
        Checks.checkIsAscii((String)welcomePageUri);
        AppModuleInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.AppModuleInfo");
        _x.welcomePageUri = welcomePageUri;
        return _x;
    }

    @Property(name="CreatedOn")
    @JsonIgnore
    public Optional<String> getCreatedOn() {
        return Optional.ofNullable(this.createdOn);
    }

    public AppModuleInfo withCreatedOn(String createdOn) {
        Checks.checkIsAscii((String)createdOn);
        AppModuleInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.AppModuleInfo");
        _x.createdOn = createdOn;
        return _x;
    }

    @Property(name="CreatedBy")
    @JsonIgnore
    public Optional<String> getCreatedBy() {
        return Optional.ofNullable(this.createdBy);
    }

    public AppModuleInfo withCreatedBy(String createdBy) {
        Checks.checkIsAscii((String)createdBy);
        AppModuleInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.AppModuleInfo");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="ModifiedOn")
    @JsonIgnore
    public Optional<String> getModifiedOn() {
        return Optional.ofNullable(this.modifiedOn);
    }

    public AppModuleInfo withModifiedOn(String modifiedOn) {
        Checks.checkIsAscii((String)modifiedOn);
        AppModuleInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.AppModuleInfo");
        _x.modifiedOn = modifiedOn;
        return _x;
    }

    @Property(name="ModifiedBy")
    @JsonIgnore
    public Optional<String> getModifiedBy() {
        return Optional.ofNullable(this.modifiedBy);
    }

    public AppModuleInfo withModifiedBy(String modifiedBy) {
        Checks.checkIsAscii((String)modifiedBy);
        AppModuleInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.AppModuleInfo");
        _x.modifiedBy = modifiedBy;
        return _x;
    }

    @Property(name="AppUri")
    @JsonIgnore
    public Optional<String> getAppUri() {
        return Optional.ofNullable(this.appUri);
    }

    public AppModuleInfo withAppUri(String appUri) {
        Checks.checkIsAscii((String)appUri);
        AppModuleInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.AppModuleInfo");
        _x.appUri = appUri;
        return _x;
    }

    @Property(name="IsDefault")
    @JsonIgnore
    public Optional<Boolean> getIsDefault() {
        return Optional.ofNullable(this.isDefault);
    }

    public AppModuleInfo withIsDefault(Boolean isDefault) {
        AppModuleInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.AppModuleInfo");
        _x.isDefault = isDefault;
        return _x;
    }

    @Property(name="ClientType")
    @JsonIgnore
    public Optional<Integer> getClientType() {
        return Optional.ofNullable(this.clientType);
    }

    public AppModuleInfo withClientType(Integer clientType) {
        AppModuleInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.AppModuleInfo");
        _x.clientType = clientType;
        return _x;
    }

    @Property(name="NavigationType")
    @JsonIgnore
    public Optional<Integer> getNavigationType() {
        return Optional.ofNullable(this.navigationType);
    }

    public AppModuleInfo withNavigationType(Integer navigationType) {
        AppModuleInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.AppModuleInfo");
        _x.navigationType = navigationType;
        return _x;
    }

    @Property(name="OptimizedFor")
    @JsonIgnore
    public Optional<String> getOptimizedFor() {
        return Optional.ofNullable(this.optimizedFor);
    }

    public AppModuleInfo withOptimizedFor(String optimizedFor) {
        Checks.checkIsAscii((String)optimizedFor);
        AppModuleInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.AppModuleInfo");
        _x.optimizedFor = optimizedFor;
        return _x;
    }

    @Property(name="AppSettingDetails")
    @JsonIgnore
    public CollectionPage<AppSettingDetails> getAppSettingDetails() {
        return new CollectionPage(this.contextPath, AppSettingDetails.class, this.appSettingDetails, Optional.ofNullable(this.appSettingDetailsNextLink), (com.github.davidmoten.odata.client.SchemaInfo)SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="AppSettingDetails")
    @JsonIgnore
    public CollectionPage<AppSettingDetails> getAppSettingDetails(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, AppSettingDetails.class, this.appSettingDetails, Optional.ofNullable(this.appSettingDetailsNextLink), (com.github.davidmoten.odata.client.SchemaInfo)SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFields();
        }
        this.unmappedFields.put(name, (java.lang.Object)value);
    }

    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields == null ? UnmappedFields.EMPTY : this.unmappedFields;
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private AppModuleInfo _copy() {
        AppModuleInfo _x = new AppModuleInfo();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields;
        _x.odataType = this.odataType;
        _x.appId = this.appId;
        _x.appDisplayName = this.appDisplayName;
        _x.publisherName = this.publisherName;
        _x.publishedOn = this.publishedOn;
        _x.appUniqueName = this.appUniqueName;
        _x.appVersion = this.appVersion;
        _x.description = this.description;
        _x.webResourceUri = this.webResourceUri;
        _x.welcomePageUri = this.welcomePageUri;
        _x.createdOn = this.createdOn;
        _x.createdBy = this.createdBy;
        _x.modifiedOn = this.modifiedOn;
        _x.modifiedBy = this.modifiedBy;
        _x.appUri = this.appUri;
        _x.isDefault = this.isDefault;
        _x.clientType = this.clientType;
        _x.navigationType = this.navigationType;
        _x.optimizedFor = this.optimizedFor;
        _x.appSettingDetails = this.appSettingDetails;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppModuleInfo[");
        b.append("AppId=");
        b.append(this.appId);
        b.append(", ");
        b.append("AppDisplayName=");
        b.append(this.appDisplayName);
        b.append(", ");
        b.append("PublisherName=");
        b.append(this.publisherName);
        b.append(", ");
        b.append("PublishedOn=");
        b.append(this.publishedOn);
        b.append(", ");
        b.append("AppUniqueName=");
        b.append(this.appUniqueName);
        b.append(", ");
        b.append("AppVersion=");
        b.append(this.appVersion);
        b.append(", ");
        b.append("Description=");
        b.append(this.description);
        b.append(", ");
        b.append("WebResourceUri=");
        b.append(this.webResourceUri);
        b.append(", ");
        b.append("WelcomePageUri=");
        b.append(this.welcomePageUri);
        b.append(", ");
        b.append("CreatedOn=");
        b.append(this.createdOn);
        b.append(", ");
        b.append("CreatedBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("ModifiedOn=");
        b.append(this.modifiedOn);
        b.append(", ");
        b.append("ModifiedBy=");
        b.append(this.modifiedBy);
        b.append(", ");
        b.append("AppUri=");
        b.append(this.appUri);
        b.append(", ");
        b.append("IsDefault=");
        b.append(this.isDefault);
        b.append(", ");
        b.append("ClientType=");
        b.append(this.clientType);
        b.append(", ");
        b.append("NavigationType=");
        b.append(this.navigationType);
        b.append(", ");
        b.append("OptimizedFor=");
        b.append(this.optimizedFor);
        b.append(", ");
        b.append("AppSettingDetails=");
        b.append(this.appSettingDetails);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private String appId;
        private String appDisplayName;
        private String publisherName;
        private String publishedOn;
        private String appUniqueName;
        private String appVersion;
        private String description;
        private String webResourceUri;
        private String welcomePageUri;
        private String createdOn;
        private String createdBy;
        private String modifiedOn;
        private String modifiedBy;
        private String appUri;
        private Boolean isDefault;
        private Integer clientType;
        private Integer navigationType;
        private String optimizedFor;
        private List<AppSettingDetails> appSettingDetails;
        private String appSettingDetailsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder appId(String appId) {
            this.appId = appId;
            this.changedFields = this.changedFields.add("AppId");
            return this;
        }

        public Builder appDisplayName(String appDisplayName) {
            this.appDisplayName = appDisplayName;
            this.changedFields = this.changedFields.add("AppDisplayName");
            return this;
        }

        public Builder publisherName(String publisherName) {
            this.publisherName = publisherName;
            this.changedFields = this.changedFields.add("PublisherName");
            return this;
        }

        public Builder publishedOn(String publishedOn) {
            this.publishedOn = publishedOn;
            this.changedFields = this.changedFields.add("PublishedOn");
            return this;
        }

        public Builder appUniqueName(String appUniqueName) {
            this.appUniqueName = appUniqueName;
            this.changedFields = this.changedFields.add("AppUniqueName");
            return this;
        }

        public Builder appVersion(String appVersion) {
            this.appVersion = appVersion;
            this.changedFields = this.changedFields.add("AppVersion");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = this.changedFields.add("Description");
            return this;
        }

        public Builder webResourceUri(String webResourceUri) {
            this.webResourceUri = webResourceUri;
            this.changedFields = this.changedFields.add("WebResourceUri");
            return this;
        }

        public Builder welcomePageUri(String welcomePageUri) {
            this.welcomePageUri = welcomePageUri;
            this.changedFields = this.changedFields.add("WelcomePageUri");
            return this;
        }

        public Builder createdOn(String createdOn) {
            this.createdOn = createdOn;
            this.changedFields = this.changedFields.add("CreatedOn");
            return this;
        }

        public Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            this.changedFields = this.changedFields.add("CreatedBy");
            return this;
        }

        public Builder modifiedOn(String modifiedOn) {
            this.modifiedOn = modifiedOn;
            this.changedFields = this.changedFields.add("ModifiedOn");
            return this;
        }

        public Builder modifiedBy(String modifiedBy) {
            this.modifiedBy = modifiedBy;
            this.changedFields = this.changedFields.add("ModifiedBy");
            return this;
        }

        public Builder appUri(String appUri) {
            this.appUri = appUri;
            this.changedFields = this.changedFields.add("AppUri");
            return this;
        }

        public Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            this.changedFields = this.changedFields.add("IsDefault");
            return this;
        }

        public Builder clientType(Integer clientType) {
            this.clientType = clientType;
            this.changedFields = this.changedFields.add("ClientType");
            return this;
        }

        public Builder navigationType(Integer navigationType) {
            this.navigationType = navigationType;
            this.changedFields = this.changedFields.add("NavigationType");
            return this;
        }

        public Builder optimizedFor(String optimizedFor) {
            this.optimizedFor = optimizedFor;
            this.changedFields = this.changedFields.add("OptimizedFor");
            return this;
        }

        public Builder appSettingDetails(List<AppSettingDetails> appSettingDetails) {
            this.appSettingDetails = appSettingDetails;
            this.changedFields = this.changedFields.add("AppSettingDetails");
            return this;
        }

        public Builder appSettingDetails(AppSettingDetails ... appSettingDetails) {
            return this.appSettingDetails(Arrays.asList(appSettingDetails));
        }

        public Builder appSettingDetailsNextLink(String appSettingDetailsNextLink) {
            this.appSettingDetailsNextLink = appSettingDetailsNextLink;
            this.changedFields = this.changedFields.add("AppSettingDetails");
            return this;
        }

        public AppModuleInfo build() {
            AppModuleInfo _x = new AppModuleInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "Microsoft.Dynamics.CRM.AppModuleInfo";
            _x.appId = this.appId;
            _x.appDisplayName = this.appDisplayName;
            _x.publisherName = this.publisherName;
            _x.publishedOn = this.publishedOn;
            _x.appUniqueName = this.appUniqueName;
            _x.appVersion = this.appVersion;
            _x.description = this.description;
            _x.webResourceUri = this.webResourceUri;
            _x.welcomePageUri = this.welcomePageUri;
            _x.createdOn = this.createdOn;
            _x.createdBy = this.createdBy;
            _x.modifiedOn = this.modifiedOn;
            _x.modifiedBy = this.modifiedBy;
            _x.appUri = this.appUri;
            _x.isDefault = this.isDefault;
            _x.clientType = this.clientType;
            _x.navigationType = this.navigationType;
            _x.optimizedFor = this.optimizedFor;
            _x.appSettingDetails = this.appSettingDetails;
            _x.appSettingDetailsNextLink = this.appSettingDetailsNextLink;
            return _x;
        }
    }
}

