/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import microsoft.dynamics.crm.complex.ArtifactIdType;
import microsoft.dynamics.crm.complex.Object;
import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonPropertyOrder(value={"@odata.type", "EntityId", "ChartIds", "Forms", "Views", "EntityDashboards"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AppEntityInfo
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="EntityId")
    protected String entityId;
    @JsonProperty(value="ChartIds")
    protected List<String> chartIds;
    @JsonProperty(value="ChartIds@nextLink")
    protected String chartIdsNextLink;
    @JsonProperty(value="Forms")
    protected List<ArtifactIdType> forms;
    @JsonProperty(value="Forms@nextLink")
    protected String formsNextLink;
    @JsonProperty(value="Views")
    protected List<ArtifactIdType> views;
    @JsonProperty(value="Views@nextLink")
    protected String viewsNextLink;
    @JsonProperty(value="EntityDashboards")
    protected List<ArtifactIdType> entityDashboards;
    @JsonProperty(value="EntityDashboards@nextLink")
    protected String entityDashboardsNextLink;

    protected AppEntityInfo() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.AppEntityInfo";
    }

    @Property(name="EntityId")
    @JsonIgnore
    public Optional<String> getEntityId() {
        return Optional.ofNullable(this.entityId);
    }

    public AppEntityInfo withEntityId(String entityId) {
        Checks.checkIsAscii((String)entityId);
        AppEntityInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.AppEntityInfo");
        _x.entityId = entityId;
        return _x;
    }

    @Property(name="ChartIds")
    @JsonIgnore
    public CollectionPage<String> getChartIds() {
        return new CollectionPage(this.contextPath, String.class, this.chartIds, Optional.ofNullable(this.chartIdsNextLink), (com.github.davidmoten.odata.client.SchemaInfo)EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="ChartIds")
    @JsonIgnore
    public CollectionPage<String> getChartIds(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, String.class, this.chartIds, Optional.ofNullable(this.chartIdsNextLink), (com.github.davidmoten.odata.client.SchemaInfo)EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="Forms")
    @JsonIgnore
    public CollectionPage<ArtifactIdType> getForms() {
        return new CollectionPage(this.contextPath, ArtifactIdType.class, this.forms, Optional.ofNullable(this.formsNextLink), (com.github.davidmoten.odata.client.SchemaInfo)SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Forms")
    @JsonIgnore
    public CollectionPage<ArtifactIdType> getForms(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, ArtifactIdType.class, this.forms, Optional.ofNullable(this.formsNextLink), (com.github.davidmoten.odata.client.SchemaInfo)SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="Views")
    @JsonIgnore
    public CollectionPage<ArtifactIdType> getViews() {
        return new CollectionPage(this.contextPath, ArtifactIdType.class, this.views, Optional.ofNullable(this.viewsNextLink), (com.github.davidmoten.odata.client.SchemaInfo)SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Views")
    @JsonIgnore
    public CollectionPage<ArtifactIdType> getViews(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, ArtifactIdType.class, this.views, Optional.ofNullable(this.viewsNextLink), (com.github.davidmoten.odata.client.SchemaInfo)SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="EntityDashboards")
    @JsonIgnore
    public CollectionPage<ArtifactIdType> getEntityDashboards() {
        return new CollectionPage(this.contextPath, ArtifactIdType.class, this.entityDashboards, Optional.ofNullable(this.entityDashboardsNextLink), (com.github.davidmoten.odata.client.SchemaInfo)SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="EntityDashboards")
    @JsonIgnore
    public CollectionPage<ArtifactIdType> getEntityDashboards(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, ArtifactIdType.class, this.entityDashboards, Optional.ofNullable(this.entityDashboardsNextLink), (com.github.davidmoten.odata.client.SchemaInfo)SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFields();
        }
        this.unmappedFields.put(name, (java.lang.Object)value);
    }

    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields == null ? UnmappedFields.EMPTY : this.unmappedFields;
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private AppEntityInfo _copy() {
        AppEntityInfo _x = new AppEntityInfo();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields;
        _x.odataType = this.odataType;
        _x.entityId = this.entityId;
        _x.chartIds = this.chartIds;
        _x.forms = this.forms;
        _x.views = this.views;
        _x.entityDashboards = this.entityDashboards;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppEntityInfo[");
        b.append("EntityId=");
        b.append(this.entityId);
        b.append(", ");
        b.append("ChartIds=");
        b.append(this.chartIds);
        b.append(", ");
        b.append("Forms=");
        b.append(this.forms);
        b.append(", ");
        b.append("Views=");
        b.append(this.views);
        b.append(", ");
        b.append("EntityDashboards=");
        b.append(this.entityDashboards);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private String entityId;
        private List<String> chartIds;
        private String chartIdsNextLink;
        private List<ArtifactIdType> forms;
        private String formsNextLink;
        private List<ArtifactIdType> views;
        private String viewsNextLink;
        private List<ArtifactIdType> entityDashboards;
        private String entityDashboardsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder entityId(String entityId) {
            this.entityId = entityId;
            this.changedFields = this.changedFields.add("EntityId");
            return this;
        }

        public Builder chartIds(List<String> chartIds) {
            this.chartIds = chartIds;
            this.changedFields = this.changedFields.add("ChartIds");
            return this;
        }

        public Builder chartIds(String ... chartIds) {
            return this.chartIds(Arrays.asList(chartIds));
        }

        public Builder chartIdsNextLink(String chartIdsNextLink) {
            this.chartIdsNextLink = chartIdsNextLink;
            this.changedFields = this.changedFields.add("ChartIds");
            return this;
        }

        public Builder forms(List<ArtifactIdType> forms) {
            this.forms = forms;
            this.changedFields = this.changedFields.add("Forms");
            return this;
        }

        public Builder forms(ArtifactIdType ... forms) {
            return this.forms(Arrays.asList(forms));
        }

        public Builder formsNextLink(String formsNextLink) {
            this.formsNextLink = formsNextLink;
            this.changedFields = this.changedFields.add("Forms");
            return this;
        }

        public Builder views(List<ArtifactIdType> views) {
            this.views = views;
            this.changedFields = this.changedFields.add("Views");
            return this;
        }

        public Builder views(ArtifactIdType ... views) {
            return this.views(Arrays.asList(views));
        }

        public Builder viewsNextLink(String viewsNextLink) {
            this.viewsNextLink = viewsNextLink;
            this.changedFields = this.changedFields.add("Views");
            return this;
        }

        public Builder entityDashboards(List<ArtifactIdType> entityDashboards) {
            this.entityDashboards = entityDashboards;
            this.changedFields = this.changedFields.add("EntityDashboards");
            return this;
        }

        public Builder entityDashboards(ArtifactIdType ... entityDashboards) {
            return this.entityDashboards(Arrays.asList(entityDashboards));
        }

        public Builder entityDashboardsNextLink(String entityDashboardsNextLink) {
            this.entityDashboardsNextLink = entityDashboardsNextLink;
            this.changedFields = this.changedFields.add("EntityDashboards");
            return this;
        }

        public AppEntityInfo build() {
            AppEntityInfo _x = new AppEntityInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "Microsoft.Dynamics.CRM.AppEntityInfo";
            _x.entityId = this.entityId;
            _x.chartIds = this.chartIds;
            _x.chartIdsNextLink = this.chartIdsNextLink;
            _x.forms = this.forms;
            _x.formsNextLink = this.formsNextLink;
            _x.views = this.views;
            _x.viewsNextLink = this.viewsNextLink;
            _x.entityDashboards = this.entityDashboards;
            _x.entityDashboardsNextLink = this.entityDashboardsNextLink;
            return _x;
        }
    }
}

