/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import microsoft.dynamics.crm.complex.AppEntityInfo;
import microsoft.dynamics.crm.complex.AppInfo;
import microsoft.dynamics.crm.complex.CanvasAppsInfo;
import microsoft.dynamics.crm.complex.Object;
import microsoft.dynamics.crm.schema.SchemaInfo;

@JsonPropertyOrder(value={"@odata.type", "appInfo", "SitemapId", "bpfIds", "dashboardIds", "appEntityInfo", "CanvasApps"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AppContext
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="appInfo")
    protected AppInfo appInfo;
    @JsonProperty(value="SitemapId")
    protected String sitemapId;
    @JsonProperty(value="bpfIds")
    protected List<String> bpfIds;
    @JsonProperty(value="bpfIds@nextLink")
    protected String bpfIdsNextLink;
    @JsonProperty(value="dashboardIds")
    protected List<String> dashboardIds;
    @JsonProperty(value="dashboardIds@nextLink")
    protected String dashboardIdsNextLink;
    @JsonProperty(value="appEntityInfo")
    protected List<AppEntityInfo> appEntityInfo;
    @JsonProperty(value="appEntityInfo@nextLink")
    protected String appEntityInfoNextLink;
    @JsonProperty(value="CanvasApps")
    protected List<CanvasAppsInfo> canvasApps;
    @JsonProperty(value="CanvasApps@nextLink")
    protected String canvasAppsNextLink;

    protected AppContext() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.AppContext";
    }

    @Property(name="appInfo")
    @JsonIgnore
    public Optional<AppInfo> getAppInfo() {
        return Optional.ofNullable(this.appInfo);
    }

    public AppContext withAppInfo(AppInfo appInfo) {
        AppContext _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.AppContext");
        _x.appInfo = appInfo;
        return _x;
    }

    @Property(name="SitemapId")
    @JsonIgnore
    public Optional<String> getSitemapId() {
        return Optional.ofNullable(this.sitemapId);
    }

    public AppContext withSitemapId(String sitemapId) {
        Checks.checkIsAscii((String)sitemapId);
        AppContext _x = this._copy();
        _x.odataType = (String)Util.nvl((java.lang.Object)this.odataType, (java.lang.Object)"Microsoft.Dynamics.CRM.AppContext");
        _x.sitemapId = sitemapId;
        return _x;
    }

    @Property(name="bpfIds")
    @JsonIgnore
    public CollectionPage<String> getBpfIds() {
        return new CollectionPage(this.contextPath, String.class, this.bpfIds, Optional.ofNullable(this.bpfIdsNextLink), (com.github.davidmoten.odata.client.SchemaInfo)EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="bpfIds")
    @JsonIgnore
    public CollectionPage<String> getBpfIds(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, String.class, this.bpfIds, Optional.ofNullable(this.bpfIdsNextLink), (com.github.davidmoten.odata.client.SchemaInfo)EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="dashboardIds")
    @JsonIgnore
    public CollectionPage<String> getDashboardIds() {
        return new CollectionPage(this.contextPath, String.class, this.dashboardIds, Optional.ofNullable(this.dashboardIdsNextLink), (com.github.davidmoten.odata.client.SchemaInfo)EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="dashboardIds")
    @JsonIgnore
    public CollectionPage<String> getDashboardIds(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, String.class, this.dashboardIds, Optional.ofNullable(this.dashboardIdsNextLink), (com.github.davidmoten.odata.client.SchemaInfo)EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="appEntityInfo")
    @JsonIgnore
    public CollectionPage<AppEntityInfo> getAppEntityInfo() {
        return new CollectionPage(this.contextPath, AppEntityInfo.class, this.appEntityInfo, Optional.ofNullable(this.appEntityInfoNextLink), (com.github.davidmoten.odata.client.SchemaInfo)SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="appEntityInfo")
    @JsonIgnore
    public CollectionPage<AppEntityInfo> getAppEntityInfo(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, AppEntityInfo.class, this.appEntityInfo, Optional.ofNullable(this.appEntityInfoNextLink), (com.github.davidmoten.odata.client.SchemaInfo)SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="CanvasApps")
    @JsonIgnore
    public CollectionPage<CanvasAppsInfo> getCanvasApps() {
        return new CollectionPage(this.contextPath, CanvasAppsInfo.class, this.canvasApps, Optional.ofNullable(this.canvasAppsNextLink), (com.github.davidmoten.odata.client.SchemaInfo)SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="CanvasApps")
    @JsonIgnore
    public CollectionPage<CanvasAppsInfo> getCanvasApps(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, CanvasAppsInfo.class, this.canvasApps, Optional.ofNullable(this.canvasAppsNextLink), (com.github.davidmoten.odata.client.SchemaInfo)SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFields();
        }
        this.unmappedFields.put(name, (java.lang.Object)value);
    }

    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields == null ? UnmappedFields.EMPTY : this.unmappedFields;
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private AppContext _copy() {
        AppContext _x = new AppContext();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields;
        _x.odataType = this.odataType;
        _x.appInfo = this.appInfo;
        _x.sitemapId = this.sitemapId;
        _x.bpfIds = this.bpfIds;
        _x.dashboardIds = this.dashboardIds;
        _x.appEntityInfo = this.appEntityInfo;
        _x.canvasApps = this.canvasApps;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppContext[");
        b.append("appInfo=");
        b.append(this.appInfo);
        b.append(", ");
        b.append("SitemapId=");
        b.append(this.sitemapId);
        b.append(", ");
        b.append("bpfIds=");
        b.append(this.bpfIds);
        b.append(", ");
        b.append("dashboardIds=");
        b.append(this.dashboardIds);
        b.append(", ");
        b.append("appEntityInfo=");
        b.append(this.appEntityInfo);
        b.append(", ");
        b.append("CanvasApps=");
        b.append(this.canvasApps);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private AppInfo appInfo;
        private String sitemapId;
        private List<String> bpfIds;
        private String bpfIdsNextLink;
        private List<String> dashboardIds;
        private String dashboardIdsNextLink;
        private List<AppEntityInfo> appEntityInfo;
        private String appEntityInfoNextLink;
        private List<CanvasAppsInfo> canvasApps;
        private String canvasAppsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder appInfo(AppInfo appInfo) {
            this.appInfo = appInfo;
            this.changedFields = this.changedFields.add("appInfo");
            return this;
        }

        public Builder sitemapId(String sitemapId) {
            this.sitemapId = sitemapId;
            this.changedFields = this.changedFields.add("SitemapId");
            return this;
        }

        public Builder bpfIds(List<String> bpfIds) {
            this.bpfIds = bpfIds;
            this.changedFields = this.changedFields.add("bpfIds");
            return this;
        }

        public Builder bpfIds(String ... bpfIds) {
            return this.bpfIds(Arrays.asList(bpfIds));
        }

        public Builder bpfIdsNextLink(String bpfIdsNextLink) {
            this.bpfIdsNextLink = bpfIdsNextLink;
            this.changedFields = this.changedFields.add("bpfIds");
            return this;
        }

        public Builder dashboardIds(List<String> dashboardIds) {
            this.dashboardIds = dashboardIds;
            this.changedFields = this.changedFields.add("dashboardIds");
            return this;
        }

        public Builder dashboardIds(String ... dashboardIds) {
            return this.dashboardIds(Arrays.asList(dashboardIds));
        }

        public Builder dashboardIdsNextLink(String dashboardIdsNextLink) {
            this.dashboardIdsNextLink = dashboardIdsNextLink;
            this.changedFields = this.changedFields.add("dashboardIds");
            return this;
        }

        public Builder appEntityInfo(List<AppEntityInfo> appEntityInfo) {
            this.appEntityInfo = appEntityInfo;
            this.changedFields = this.changedFields.add("appEntityInfo");
            return this;
        }

        public Builder appEntityInfo(AppEntityInfo ... appEntityInfo) {
            return this.appEntityInfo(Arrays.asList(appEntityInfo));
        }

        public Builder appEntityInfoNextLink(String appEntityInfoNextLink) {
            this.appEntityInfoNextLink = appEntityInfoNextLink;
            this.changedFields = this.changedFields.add("appEntityInfo");
            return this;
        }

        public Builder canvasApps(List<CanvasAppsInfo> canvasApps) {
            this.canvasApps = canvasApps;
            this.changedFields = this.changedFields.add("CanvasApps");
            return this;
        }

        public Builder canvasApps(CanvasAppsInfo ... canvasApps) {
            return this.canvasApps(Arrays.asList(canvasApps));
        }

        public Builder canvasAppsNextLink(String canvasAppsNextLink) {
            this.canvasAppsNextLink = canvasAppsNextLink;
            this.changedFields = this.changedFields.add("CanvasApps");
            return this;
        }

        public AppContext build() {
            AppContext _x = new AppContext();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "Microsoft.Dynamics.CRM.AppContext";
            _x.appInfo = this.appInfo;
            _x.sitemapId = this.sitemapId;
            _x.bpfIds = this.bpfIds;
            _x.bpfIdsNextLink = this.bpfIdsNextLink;
            _x.dashboardIds = this.dashboardIds;
            _x.dashboardIdsNextLink = this.dashboardIdsNextLink;
            _x.appEntityInfo = this.appEntityInfo;
            _x.appEntityInfoNextLink = this.appEntityInfoNextLink;
            _x.canvasApps = this.canvasApps;
            _x.canvasAppsNextLink = this.canvasAppsNextLink;
            return _x;
        }
    }
}

