package microsoft.vs.analytics.v4.myorg.entity.set;

import com.github.davidmoten.odata.client.ContextPath;

import java.util.Optional;

import microsoft.vs.analytics.v4.model.entity.collection.request.TestSuiteCollectionRequest;

public final class TestSuites extends TestSuiteCollectionRequest {

    public TestSuites(ContextPath contextPath) {
        super(contextPath, Optional.empty());
    }

    public Projects project() {
        return new Projects(contextPath.addSegment("Project"));
    }

    public WorkItems testSuiteWorkItem() {
        return new WorkItems(contextPath.addSegment("TestSuiteWorkItem"));
    }

    public WorkItems testPlanWorkItem() {
        return new WorkItems(contextPath.addSegment("TestPlanWorkItem"));
    }

    public WorkItems requirementWorkItem() {
        return new WorkItems(contextPath.addSegment("RequirementWorkItem"));
    }
}
