package microsoft.vs.analytics.v4.myorg.entity.set;

import com.github.davidmoten.odata.client.ContextPath;

import java.util.Optional;

import microsoft.vs.analytics.v4.model.entity.collection.request.TestResultDailyCollectionRequest;

public final class TestResultsDaily extends TestResultDailyCollectionRequest {

    public TestResultsDaily(ContextPath contextPath) {
        super(contextPath, Optional.empty());
    }

    public Projects project() {
        return new Projects(contextPath.addSegment("Project"));
    }

    public Tests test() {
        return new Tests(contextPath.addSegment("Test"));
    }

    public Pipelines pipeline() {
        return new Pipelines(contextPath.addSegment("Pipeline"));
    }

    public Branches branch() {
        return new Branches(contextPath.addSegment("Branch"));
    }

    public Dates date() {
        return new Dates(contextPath.addSegment("Date"));
    }
}
