package microsoft.vs.analytics.v4.myorg.entity.set;

import com.github.davidmoten.odata.client.ContextPath;

import java.util.Optional;

import microsoft.vs.analytics.v4.model.entity.collection.request.TestPointHistorySnapshotCollectionRequest;

public final class TestPointHistorySnapshot extends TestPointHistorySnapshotCollectionRequest {

    public TestPointHistorySnapshot(ContextPath contextPath) {
        super(contextPath, Optional.empty());
    }

    public Dates date() {
        return new Dates(contextPath.addSegment("Date"));
    }

    public Projects project() {
        return new Projects(contextPath.addSegment("Project"));
    }

    public TestSuites testSuite() {
        return new TestSuites(contextPath.addSegment("TestSuite"));
    }

    public TestConfigurations testConfiguration() {
        return new TestConfigurations(contextPath.addSegment("TestConfiguration"));
    }

    public WorkItems testCase() {
        return new WorkItems(contextPath.addSegment("TestCase"));
    }

    public Users tester() {
        return new Users(contextPath.addSegment("Tester"));
    }

    public Users assignedTo() {
        return new Users(contextPath.addSegment("AssignedTo"));
    }
}
