package microsoft.vs.analytics.v4.myorg.entity.set;

import com.github.davidmoten.odata.client.ContextPath;

import java.util.Optional;

import microsoft.vs.analytics.v4.model.entity.collection.request.PipelineRunCollectionRequest;

public final class PipelineRuns extends PipelineRunCollectionRequest {

    public PipelineRuns(ContextPath contextPath) {
        super(contextPath, Optional.empty());
    }

    public Projects project() {
        return new Projects(contextPath.addSegment("Project"));
    }

    public Pipelines pipeline() {
        return new Pipelines(contextPath.addSegment("Pipeline"));
    }

    public Branches branch() {
        return new Branches(contextPath.addSegment("Branch"));
    }

    public Dates queuedOn() {
        return new Dates(contextPath.addSegment("QueuedOn"));
    }

    public Dates startedOn() {
        return new Dates(contextPath.addSegment("StartedOn"));
    }

    public Dates completedOn() {
        return new Dates(contextPath.addSegment("CompletedOn"));
    }
}
