package microsoft.vs.analytics.v4.myorg.entity.set;

import com.github.davidmoten.odata.client.ContextPath;

import java.util.Optional;

import microsoft.vs.analytics.v4.model.entity.collection.request.PipelineRunActivityResultCollectionRequest;

public final class PipelineRunActivityResults extends PipelineRunActivityResultCollectionRequest {

    public PipelineRunActivityResults(ContextPath contextPath) {
        super(contextPath, Optional.empty());
    }

    public Projects project() {
        return new Projects(contextPath.addSegment("Project"));
    }

    public Pipelines pipeline() {
        return new Pipelines(contextPath.addSegment("Pipeline"));
    }

    public PipelineTasks pipelineTask() {
        return new PipelineTasks(contextPath.addSegment("PipelineTask"));
    }

    public PipelineJobs pipelineJob() {
        return new PipelineJobs(contextPath.addSegment("PipelineJob"));
    }

    public Branches branch() {
        return new Branches(contextPath.addSegment("Branch"));
    }

    public Dates pipelineRunQueuedOn() {
        return new Dates(contextPath.addSegment("PipelineRunQueuedOn"));
    }

    public Dates pipelineRunStartedOn() {
        return new Dates(contextPath.addSegment("PipelineRunStartedOn"));
    }

    public Dates pipelineRunCompletedOn() {
        return new Dates(contextPath.addSegment("PipelineRunCompletedOn"));
    }

    public Dates activityStartedOn() {
        return new Dates(contextPath.addSegment("ActivityStartedOn"));
    }

    public Dates activityCompletedOn() {
        return new Dates(contextPath.addSegment("ActivityCompletedOn"));
    }
}
