package microsoft.vs.analytics.v4.model.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum TestSuiteType implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("QueryBased")
    QUERY_BASED("QueryBased", "1"),

    @JsonProperty("Static")
    STATIC("Static", "2"),

    @JsonProperty("RequirementBased")
    REQUIREMENT_BASED("RequirementBased", "3");

    private final String name;
    private final String value;

    private TestSuiteType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
