package microsoft.vs.analytics.v4.model.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum TestResultState implements Enum {

    @JsonProperty("Unspecified")
    UNSPECIFIED("Unspecified", "0"),

    @JsonProperty("Pending")
    PENDING("Pending", "1"),

    @JsonProperty("Queued")
    QUEUED("Queued", "2"),

    @JsonProperty("InProgress")
    IN_PROGRESS("InProgress", "3"),

    @JsonProperty("Paused")
    PAUSED("Paused", "4"),

    @JsonProperty("Completed")
    COMPLETED("Completed", "5");

    private final String name;
    private final String value;

    private TestResultState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
