package microsoft.vs.analytics.v4.model.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum TestOutcome implements Enum {

    @JsonProperty("Unspecified")
    UNSPECIFIED("Unspecified", "0"),

    @JsonProperty("None")
    NONE("None", "1"),

    @JsonProperty("Passed")
    PASSED("Passed", "2"),

    @JsonProperty("Failed")
    FAILED("Failed", "3"),

    @JsonProperty("Inconclusive")
    INCONCLUSIVE("Inconclusive", "4"),

    @JsonProperty("Timeout")
    TIMEOUT("Timeout", "5"),

    @JsonProperty("Aborted")
    ABORTED("Aborted", "6"),

    @JsonProperty("Blocked")
    BLOCKED("Blocked", "7"),

    @JsonProperty("NotExecuted")
    NOT_EXECUTED("NotExecuted", "8"),

    @JsonProperty("Warning")
    WARNING("Warning", "9"),

    @JsonProperty("Error")
    ERROR("Error", "10"),

    @JsonProperty("NotApplicable")
    NOT_APPLICABLE("NotApplicable", "11"),

    @JsonProperty("Paused")
    PAUSED("Paused", "12"),

    @JsonProperty("InProgress")
    IN_PROGRESS("InProgress", "13"),

    @JsonProperty("NotImpacted")
    NOT_IMPACTED("NotImpacted", "14");

    private final String name;
    private final String value;

    private TestOutcome(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
