package microsoft.vs.analytics.v4.model.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum PipelineRunTaskOutcome implements Enum {

    @JsonProperty("Succeeded")
    SUCCEEDED("Succeeded", "0"),

    @JsonProperty("SucceededWithIssues")
    SUCCEEDED_WITH_ISSUES("SucceededWithIssues", "1"),

    @JsonProperty("Failed")
    FAILED("Failed", "2"),

    @JsonProperty("Canceled")
    CANCELED("Canceled", "3"),

    @JsonProperty("Skipped")
    SKIPPED("Skipped", "4"),

    @JsonProperty("Abandoned")
    ABANDONED("Abandoned", "5");

    private final String name;
    private final String value;

    private PipelineRunTaskOutcome(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
