package microsoft.vs.analytics.v4.model.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum PipelineRunOutcome implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("Succeed")
    SUCCEED("Succeed", "2"),

    @JsonProperty("PartiallySucceeded")
    PARTIALLY_SUCCEEDED("PartiallySucceeded", "4"),

    @JsonProperty("Failed")
    FAILED("Failed", "8"),

    @JsonProperty("Canceled")
    CANCELED("Canceled", "32");

    private final String name;
    private final String value;

    private PipelineRunOutcome(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
