package microsoft.vs.analytics.v4.model.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum PipelineProcessType implements Enum {

    @JsonProperty("Designer")
    DESIGNER("Designer", "1"),

    @JsonProperty("Yaml")
    YAML("Yaml", "2"),

    @JsonProperty("Docker")
    DOCKER("Docker", "3");

    private final String name;
    private final String value;

    private PipelineProcessType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
