package microsoft.vs.analytics.v4.model.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum PipelineActivityType implements Enum {

    @JsonProperty("Task")
    TASK("Task", "0"),

    @JsonProperty("Approval")
    APPROVAL("Approval", "1"),

    @JsonProperty("AgentWait")
    AGENT_WAIT("AgentWait", "2");

    private final String name;
    private final String value;

    private PipelineActivityType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
